/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.HashMap;
import java.util.Map;

public class SumToOne {
    private static final double TOL = 1.0E-9;
    private static final Map<Integer, int[][]> SETS = new HashMap<Integer, int[][]>();
    private final int[][] _set;
    private final int _n;

    public SumToOne(int n) {
        this._set = SumToOne.getSet(n);
        this._n = n;
    }

    public double[] transform(double[] fitParms) {
        ArgChecker.isTrue((fitParms.length == this._n - 1 ? 1 : 0) != 0, (String)"length of fitParms is {}, but must be {} ", (Object[])new Object[]{fitParms.length, this._n - 1});
        double[] s2 = new double[this._n - 1];
        double[] c2 = new double[this._n - 1];
        for (int j = 0; j < this._n - 1; ++j) {
            double temp = Math.sin(fitParms[j]);
            temp *= temp;
            s2[j] = temp;
            c2[j] = 1.0 - temp;
        }
        double[] res = new double[this._n];
        for (int i = 0; i < this._n; ++i) {
            double prod = 1.0;
            for (int j = 0; j < this._n - 1; ++j) {
                if (this._set[i][j] == 1) {
                    prod *= s2[j];
                    continue;
                }
                if (this._set[i][j] != -1) continue;
                prod *= c2[j];
            }
            res[i] = prod;
        }
        return res;
    }

    public DoubleArray transform(DoubleArray fitParms) {
        return DoubleArray.copyOf((double[])this.transform(fitParms.toArray()));
    }

    public double[] inverseTransform(double[] modelParms) {
        int i;
        ArgChecker.isTrue((modelParms.length == this._n ? 1 : 0) != 0, (String)"length of modelParms is {}, but must be {} ", (Object[])new Object[]{modelParms.length, this._n});
        double[] res = new double[this._n - 1];
        double[] cum = new double[this._n + 1];
        double sum = 0.0;
        for (i = 0; i < this._n; ++i) {
            cum[i + 1] = sum += modelParms[i];
        }
        ArgChecker.isTrue((Math.abs(sum - 1.0) < 1.0E-9 ? 1 : 0) != 0, (String)"sum of elements is {}. Must be 1.0", (double)sum);
        this.cal(cum, 1.0, 0, this._n, 0, res);
        for (i = 0; i < this._n - 1; ++i) {
            res[i] = Math.asin(Math.sqrt(res[i]));
        }
        return res;
    }

    public DoubleArray inverseTransform(DoubleArray modelParms) {
        return DoubleArray.copyOf((double[])this.inverseTransform(modelParms.toArray()));
    }

    public double[][] jacobian(double[] fitParms) {
        ArgChecker.isTrue((fitParms.length == this._n - 1 ? 1 : 0) != 0, (String)"length of fitParms is {}, but must be {} ", (Object[])new Object[]{fitParms.length, this._n - 1});
        double[] sin = new double[this._n - 1];
        double[] cos = new double[this._n - 1];
        for (int j = 0; j < this._n - 1; ++j) {
            sin[j] = Math.sin(fitParms[j]);
            cos[j] = Math.cos(fitParms[j]);
        }
        double[] a = new double[this._n];
        for (int i = 0; i < this._n; ++i) {
            double prod = 1.0;
            for (int j = 0; j < this._n - 1; ++j) {
                if (this._set[i][j] == 1) {
                    prod *= sin[j];
                    continue;
                }
                if (this._set[i][j] != -1) continue;
                prod *= cos[j];
            }
            a[i] = 2.0 * prod * prod;
        }
        double[][] res = new double[this._n][this._n - 1];
        for (int i = 0; i < this._n; ++i) {
            for (int j = 0; j < this._n - 1; ++j) {
                if (this._set[i][j] == 1 && a[i] != 0.0) {
                    res[i][j] = a[i] * cos[j] / sin[j];
                    continue;
                }
                if (this._set[i][j] != -1 || a[i] == 0.0) continue;
                res[i][j] = -a[i] * sin[j] / cos[j];
            }
        }
        return res;
    }

    public DoubleMatrix jacobian(DoubleArray fitParms) {
        return DoubleMatrix.copyOf((double[][])this.jacobian(fitParms.toArray()));
    }

    private void cal(double[] cum, double factor, int d, int n, int p1, double[] res) {
        if (n == 1) {
            return;
        }
        int n1 = n / 2;
        int n2 = n - n1;
        double s = (cum[p1 + n1] - cum[p1]) * factor;
        double c = 1.0 - s;
        res[d] = s;
        this.cal(cum, factor / s, d + 1, n1, p1, res);
        this.cal(cum, factor / c, d + n1, n2, p1 + n1, res);
    }

    protected static int[][] getSet(int n) {
        ArgChecker.isTrue((n > 1 ? 1 : 0) != 0, (String)"need n>1");
        if (SETS.containsKey(n)) {
            return SETS.get(n);
        }
        Object res = new int[n][];
        switch (n) {
            case 2: {
                res[0] = new int[]{1};
                res[1] = new int[]{-1};
                break;
            }
            case 3: {
                res[0] = new int[]{1, 0};
                res[1] = new int[]{-1, 1};
                res[2] = new int[]{-1, -1};
                break;
            }
            case 4: {
                res[0] = new int[]{1, 1, 0};
                res[1] = new int[]{1, -1, 0};
                res[2] = new int[]{-1, 0, 1};
                res[3] = new int[]{-1, 0, -1};
                break;
            }
            default: {
                int i;
                int n1 = n / 2;
                int n2 = n - n1;
                int[][] set1 = SumToOne.getSet(n1);
                int[][] set2 = n1 == n2 ? set1 : SumToOne.getSet(n2);
                res = new int[n][n - 1];
                for (i = 0; i < n1; ++i) {
                    res[i][0] = 1;
                    System.arraycopy(set1[i], 0, res[i], 1, n1 - 1);
                }
                for (i = 0; i < n2; ++i) {
                    res[i + n1][0] = -1;
                    System.arraycopy(set2[i], 0, res[i + n1], n1, n2 - 1);
                }
            }
        }
        SETS.put(n, (int[][])res);
        return res;
    }
}

