/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.random;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.random.RandomNumberGenerator;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.ArrayList;
import java.util.List;

public class NormalRandomNumberGenerator
implements RandomNumberGenerator {
    private final ProbabilityDistribution<Double> normal;

    public NormalRandomNumberGenerator(double mean, double sigma) {
        ArgChecker.notNegativeOrZero((double)sigma, (String)"standard deviation");
        this.normal = new NormalDistribution(mean, sigma);
    }

    public NormalRandomNumberGenerator(double mean, double sigma, RandomEngine engine) {
        ArgChecker.notNegativeOrZero((double)sigma, (String)"standard deviation");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this.normal = new NormalDistribution(mean, sigma, engine);
    }

    @Override
    public double[] getVector(int size) {
        ArgChecker.notNegative((int)size, (String)"size");
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.normal.nextRandom();
        }
        return result;
    }

    @Override
    public List<double[]> getVectors(int arraySize, int listSize) {
        ArgChecker.notNegative((int)arraySize, (String)"arraySize");
        ArgChecker.notNegative((int)listSize, (String)"listSize");
        ArrayList<double[]> result = new ArrayList<double[]>(listSize);
        for (int i = 0; i < listSize; ++i) {
            double[] x = new double[arraySize];
            for (int j = 0; j < arraySize; ++j) {
                x[j] = this.normal.nextRandom();
            }
            result.add(x);
        }
        return result;
    }
}

