/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import java.util.function.Function;

public class BisectionSingleRootFinder
extends RealSingleRootFinder {
    private final double _accuracy;
    private static final int MAX_ITER = 100;
    private static final double ZERO = 1.0E-16;

    public BisectionSingleRootFinder() {
        this(1.0E-15);
    }

    public BisectionSingleRootFinder(double accuracy) {
        this._accuracy = Math.abs(accuracy);
    }

    @Override
    public Double getRoot(Function<Double, Double> function, Double x1, Double x2) {
        double xRoot;
        double dx;
        this.checkInputs(function, x1, x2);
        double y1 = function.apply(x1);
        double y = function.apply(x2);
        if (Math.abs(y) < this._accuracy) {
            return x2;
        }
        if (Math.abs(y1) < this._accuracy) {
            return x1;
        }
        if (y1 < 0.0) {
            dx = x2 - x1;
            xRoot = x1;
        } else {
            dx = x1 - x2;
            xRoot = x2;
        }
        for (int i = 0; i < 100; ++i) {
            double xMid = xRoot + (dx *= 0.5);
            y = function.apply(xMid);
            if (y <= 0.0) {
                xRoot = xMid;
            }
            if (!(Math.abs(dx) < this._accuracy) && !(Math.abs(y) < 1.0E-16)) continue;
            return xRoot;
        }
        throw new MathException("Could not find root in 100 attempts");
    }
}

