/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import java.util.function.Function;

public class BrentSingleRootFinder
extends RealSingleRootFinder {
    private static final int MAX_ITER = 100;
    private static final double ZERO = 1.0E-16;
    private final double _accuracy;

    public BrentSingleRootFinder() {
        this(1.0E-15);
    }

    public BrentSingleRootFinder(double accuracy) {
        this._accuracy = accuracy;
    }

    @Override
    public Double getRoot(Function<Double, Double> function, Double xLower, Double xUpper) {
        double f2;
        this.checkInputs(function, xLower, xUpper);
        if (xLower.equals(xUpper)) {
            return xLower;
        }
        double x1 = xLower;
        double x2 = xUpper;
        double x3 = xUpper;
        double delta = 0.0;
        double oldDelta = 0.0;
        double f1 = function.apply(x1);
        double f3 = f2 = function.apply(x2).doubleValue();
        for (int i = 0; i < 100; ++i) {
            if (f2 > 0.0 && f3 > 0.0 || f2 < 0.0 && f3 < 0.0) {
                x3 = x1;
                f3 = f1;
                oldDelta = delta = x2 - x1;
            }
            if (Math.abs(f3) < Math.abs(f2)) {
                x1 = x2;
                x2 = x3;
                x3 = x1;
                f1 = f2;
                f2 = f3;
                f3 = f1;
            }
            double eps = 2.0E-16 * Math.abs(x2) + 0.5 * this._accuracy;
            double xMid = (x3 - x2) / 2.0;
            if (Math.abs(xMid) <= eps) {
                return x2;
            }
            if (Math.abs(oldDelta) >= eps && Math.abs(f1) > Math.abs(f2)) {
                double min2;
                double r2;
                double r1;
                double r4 = f2 / f1;
                if (Math.abs(x1 - x3) < 1.0E-16) {
                    r1 = 2.0 * xMid * r4;
                    r2 = 1.0 - r4;
                } else {
                    r2 = f1 / f3;
                    double r3 = f2 / f3;
                    r1 = r4 * (2.0 * xMid * r2 * (r2 - r3) - (x2 - x1) * (r3 - 1.0));
                    r2 = (r2 - 1.0) * (r3 - 1.0) * (r4 - 1.0);
                }
                if (r1 > 0.0) {
                    r2 *= -1.0;
                }
                r1 = Math.abs(r1);
                double min1 = 3.0 * xMid * r2 - Math.abs(eps * r2);
                double d = min1 < (min2 = Math.abs(oldDelta * r2)) ? min1 : min2;
                if (2.0 * r1 < d) {
                    oldDelta = delta;
                    delta = r1 / r2;
                } else {
                    oldDelta = delta = xMid;
                }
            } else {
                oldDelta = delta = xMid;
            }
            x1 = x2;
            x2 = Math.abs(delta) > eps ? (x2 += delta) : (x2 += Math.copySign(eps, xMid));
            f1 = function.apply(x1);
            f2 = function.apply(x2);
            f3 = function.apply(x3);
        }
        throw new MathException("Could not converge to root in 100 attempts");
    }
}

