/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.ComplexNumber;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.rootfinding.Polynomial1DRootFinder;

public class CubicRootFinder
implements Polynomial1DRootFinder<ComplexNumber> {
    private static final double TWO_PI = Math.PI * 2;

    public ComplexNumber[] getRoots(RealPolynomialFunction1D function) {
        ArgChecker.notNull((Object)function, (String)"function");
        double[] coefficients = function.getCoefficients();
        ArgChecker.isTrue((coefficients.length == 4 ? 1 : 0) != 0, (String)"Function is not a cubic");
        double divisor = coefficients[3];
        double a = coefficients[2] / divisor;
        double b = coefficients[1] / divisor;
        double c = coefficients[0] / divisor;
        double aSq = a * a;
        double q = (aSq - 3.0 * b) / 9.0;
        double r = (2.0 * a * aSq - 9.0 * a * b + 27.0 * c) / 54.0;
        double rSq = r * r;
        double qCb = q * q * q;
        double constant = a / 3.0;
        if (rSq < qCb) {
            double mult = -2.0 * Math.sqrt(q);
            double theta = Math.acos(r / Math.sqrt(qCb));
            return new ComplexNumber[]{new ComplexNumber(mult * Math.cos(theta / 3.0) - constant, 0.0), new ComplexNumber(mult * Math.cos((theta + Math.PI * 2) / 3.0) - constant, 0.0), new ComplexNumber(mult * Math.cos((theta - Math.PI * 2) / 3.0) - constant, 0.0)};
        }
        double s = -Math.signum(r) * Math.cbrt(Math.abs(r) + Math.sqrt(rSq - qCb));
        double t = DoubleMath.fuzzyEquals((double)s, (double)0.0, (double)1.0E-16) ? 0.0 : q / s;
        double sum = s + t;
        double real = -0.5 * sum - constant;
        double imaginary = Math.sqrt(3.0) * (s - t) / 2.0;
        return new ComplexNumber[]{new ComplexNumber(sum - constant, 0.0), new ComplexNumber(real, imaginary), new ComplexNumber(real, -imaginary)};
    }
}

