/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import java.util.function.Function;

public class NewtonRaphsonSingleRootFinder
extends RealSingleRootFinder {
    private static final int MAX_ITER = 10000;
    private final double _accuracy;

    public NewtonRaphsonSingleRootFinder() {
        this(1.0E-12);
    }

    public NewtonRaphsonSingleRootFinder(double accuracy) {
        this._accuracy = Math.abs(accuracy);
    }

    @Override
    public Double getRoot(Function<Double, Double> function, Double x1, Double x2) {
        ArgChecker.notNull(function, (String)"function");
        return this.getRoot(DoubleFunction1D.from(function), x1, x2);
    }

    public Double getRoot(Function<Double, Double> function, Double x) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull((Object)x, (String)"x");
        DoubleFunction1D f = DoubleFunction1D.from(function);
        return this.getRoot(f, f.derivative(), x);
    }

    public Double getRoot(DoubleFunction1D function, Double x1, Double x2) {
        ArgChecker.notNull((Object)function, (String)"function");
        return this.getRoot(function, function.derivative(), x1, x2);
    }

    public Double getRoot(DoubleFunction1D function, Double x) {
        ArgChecker.notNull((Object)function, (String)"function");
        return this.getRoot(function, function.derivative(), x);
    }

    public Double getRoot(Function<Double, Double> function, Function<Double, Double> derivative, Double x1, Double x2) {
        this.checkInputs(function, x1, x2);
        ArgChecker.notNull(derivative, (String)"derivative");
        return this.getRoot(DoubleFunction1D.from(function), DoubleFunction1D.from(derivative), x1, x2);
    }

    public Double getRoot(Function<Double, Double> function, Function<Double, Double> derivative, Double x) {
        return this.getRoot(DoubleFunction1D.from(function), DoubleFunction1D.from(derivative), x);
    }

    public Double getRoot(DoubleFunction1D function, DoubleFunction1D derivative, Double x1, Double x2) {
        this.checkInputs(function, x1, x2);
        ArgChecker.notNull((Object)derivative, (String)"derivative function");
        double y1 = function.applyAsDouble(x1);
        if (Math.abs(y1) < this._accuracy) {
            return x1;
        }
        double y2 = function.applyAsDouble(x2);
        if (Math.abs(y2) < this._accuracy) {
            return x2;
        }
        double x = (x1 + x2) / 2.0;
        double x3 = y2 < 0.0 ? x2 : x1;
        double x4 = y2 < 0.0 ? x1 : x2;
        double xLower = x1 > x2 ? x2 : x1;
        double xUpper = x1 > x2 ? x1 : x2;
        for (int i = 0; i < 10000; ++i) {
            double dy;
            double y = function.applyAsDouble(x);
            double dx = -y / (dy = derivative.applyAsDouble(x));
            if (Math.abs(dx) <= this._accuracy) {
                return x + dx;
            }
            if ((x += dx) < xLower || x > xUpper) {
                dx = (x4 - x3) / 2.0;
                x = x3 + dx;
            }
            if (y < 0.0) {
                x3 = x;
                continue;
            }
            x4 = x;
        }
        throw new MathException("Could not find root in 10000 attempts");
    }

    public Double getRoot(DoubleFunction1D function, DoubleFunction1D derivative, Double x) {
        ArgChecker.notNull((Object)function, (String)"function");
        ArgChecker.notNull((Object)derivative, (String)"derivative function");
        ArgChecker.notNull((Object)x, (String)"x");
        double root = x;
        for (int i = 0; i < 10000; ++i) {
            double dy;
            double y = function.applyAsDouble(root);
            double dx = y / (dy = derivative.applyAsDouble(root));
            if (Math.abs(dx) <= this._accuracy) {
                return root - dx;
            }
            root -= dx;
        }
        throw new MathException("Could not find root in 10000 attempts");
    }
}

