/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.rootfinding.SingleRootFinder;
import java.util.function.Function;

public abstract class RealSingleRootFinder
implements SingleRootFinder<Double, Double> {
    public Double getRoot(Function<Double, Double> function, Double ... startingPoints) {
        ArgChecker.notNull((Object)startingPoints, (String)"startingPoints");
        ArgChecker.isTrue((startingPoints.length == 2 ? 1 : 0) != 0);
        return this.getRoot(function, startingPoints[0], startingPoints[1]);
    }

    public abstract Double getRoot(Function<Double, Double> var1, Double var2, Double var3);

    protected void checkInputs(Function<Double, Double> function, Double x1, Double x2) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull((Object)x1, (String)"x1");
        ArgChecker.notNull((Object)x2, (String)"x2");
        ArgChecker.isTrue((x1 <= x2 ? 1 : 0) != 0, (String)"x1 must be less or equal to  x2");
        ArgChecker.isTrue((function.apply(x1) * function.apply(x2) <= 0.0 ? 1 : 0) != 0, (String)"x1 and x2 do not bracket a root");
    }

    protected void checkInputs(DoubleFunction1D function, Double x1, Double x2) {
        ArgChecker.notNull((Object)function, (String)"function");
        ArgChecker.notNull((Object)x1, (String)"x1");
        ArgChecker.notNull((Object)x2, (String)"x2");
        ArgChecker.isTrue((x1 <= x2 ? 1 : 0) != 0, (String)"x1 must be less or equal to  x2");
        ArgChecker.isTrue((function.applyAsDouble(x1) * function.applyAsDouble(x2) <= 0.0 ? 1 : 0) != 0, (String)"x1 and x2 do not bracket a root");
    }
}

