/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.rootfinding.SingleRootFinder;
import java.util.function.Function;

public abstract class VectorRootFinder
implements SingleRootFinder<DoubleArray, DoubleArray> {
    public DoubleArray getRoot(Function<DoubleArray, DoubleArray> function, DoubleArray ... startingPoint) {
        ArgChecker.notNull((Object)startingPoint, (String)"starting point");
        return this.getRoot(function, startingPoint[0]);
    }

    public abstract DoubleArray getRoot(Function<DoubleArray, DoubleArray> var1, DoubleArray var2);

    protected DoubleArray checkInputsAndApplyFunction(Function<DoubleArray, DoubleArray> function, DoubleArray x0) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull((Object)x0, (String)"x0");
        int xSize = x0.size();
        for (int i = 0; i < xSize; ++i) {
            if (Doubles.isFinite((double)x0.get(i))) continue;
            throw new IllegalArgumentException("Invalid start position x0 = " + x0.toString());
        }
        DoubleArray y = function.apply(x0);
        int ySize = y.size();
        if (xSize != ySize) {
            throw new IllegalArgumentException("Invalid function result, must return an array of size " + xSize);
        }
        for (int i = 0; i < ySize; ++i) {
            if (Doubles.isFinite((double)y.get(i))) continue;
            throw new IllegalArgumentException("Invalid start position f(x0) = " + y.toString());
        }
        return y;
    }
}

