/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding.newton;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.rootfinding.newton.NewtonRootFinderMatrixInitializationFunction;
import com.opengamma.strata.math.linearalgebra.Decomposition;
import java.util.function.Function;

public class InverseJacobianEstimateInitializationFunction
implements NewtonRootFinderMatrixInitializationFunction {
    private final Decomposition<?> _decomposition;

    public InverseJacobianEstimateInitializationFunction(Decomposition<?> decomposition) {
        ArgChecker.notNull(decomposition, (String)"decomposition");
        this._decomposition = decomposition;
    }

    @Override
    public DoubleMatrix getInitializedMatrix(Function<DoubleArray, DoubleMatrix> jacobianFunction, DoubleArray x) {
        ArgChecker.notNull(jacobianFunction, (String)"jacobianFunction");
        ArgChecker.notNull((Object)x, (String)"x");
        DoubleMatrix estimate = jacobianFunction.apply(x);
        Object decompositionResult = this._decomposition.apply(estimate);
        return decompositionResult.solve(DoubleMatrix.identity((int)x.size()));
    }
}

