/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding.newton;

import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionCommons;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import com.opengamma.strata.math.impl.rootfinding.newton.BaseNewtonVectorRootFinder;
import com.opengamma.strata.math.impl.rootfinding.newton.InverseJacobianDirectionFunction;
import com.opengamma.strata.math.impl.rootfinding.newton.InverseJacobianEstimateInitializationFunction;
import com.opengamma.strata.math.impl.rootfinding.newton.ShermanMorrisonMatrixUpdateFunction;
import com.opengamma.strata.math.linearalgebra.Decomposition;

public class ShermanMorrisonVectorRootFinder
extends BaseNewtonVectorRootFinder {
    private static final double DEF_TOL = 1.0E-7;
    private static final int MAX_STEPS = 100;

    public ShermanMorrisonVectorRootFinder() {
        this(1.0E-7, 1.0E-7, 100);
    }

    public ShermanMorrisonVectorRootFinder(double absoluteTol, double relativeTol, int maxSteps) {
        this(absoluteTol, relativeTol, maxSteps, new LUDecompositionCommons());
    }

    public ShermanMorrisonVectorRootFinder(double absoluteTol, double relativeTol, int maxSteps, Decomposition<?> decomp) {
        this(absoluteTol, relativeTol, maxSteps, decomp, new OGMatrixAlgebra());
    }

    public ShermanMorrisonVectorRootFinder(double absoluteTol, double relativeTol, int maxSteps, Decomposition<?> decomp, MatrixAlgebra algebra) {
        super(absoluteTol, relativeTol, maxSteps, new InverseJacobianDirectionFunction(algebra), new InverseJacobianEstimateInitializationFunction(decomp), new ShermanMorrisonMatrixUpdateFunction(algebra));
    }
}

