/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileCalculationMethod;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileResult;

public abstract class InterpolationQuantileMethod
extends QuantileCalculationMethod {
    @Override
    protected QuantileResult quantile(double level, DoubleArray sample, boolean isExtrapolated) {
        ArgChecker.isTrue((level > 0.0 ? 1 : 0) != 0, (String)"Quantile should be above 0.");
        ArgChecker.isTrue((level < 1.0 ? 1 : 0) != 0, (String)"Quantile should be below 1.");
        int sampleSize = this.sampleCorrection(sample.size());
        double adjustedLevel = this.checkIndex(level * (double)sampleSize + this.indexCorrection(), sample.size(), isExtrapolated);
        double[] order = this.createIndexArray(sample.size());
        double[] s = sample.toArray();
        DoubleArrayMath.sortPairs((double[])s, (double[])order);
        int lowerIndex = (int)Math.floor(adjustedLevel);
        int upperIndex = (int)Math.ceil(adjustedLevel);
        double lowerWeight = (double)upperIndex - adjustedLevel;
        double upperWeight = 1.0 - lowerWeight;
        return QuantileResult.of(lowerWeight * s[lowerIndex - 1] + upperWeight * s[upperIndex - 1], new int[]{(int)order[lowerIndex - 1], (int)order[upperIndex - 1]}, DoubleArray.of((double)lowerWeight, (double)upperWeight));
    }

    @Override
    protected QuantileResult expectedShortfall(double level, DoubleArray sample) {
        ArgChecker.isTrue((level > 0.0 ? 1 : 0) != 0, (String)"Quantile should be above 0.");
        ArgChecker.isTrue((level < 1.0 ? 1 : 0) != 0, (String)"Quantile should be below 1.");
        int sampleSize = this.sampleCorrection(sample.size());
        double fractionalIndex = level * (double)sampleSize + this.indexCorrection();
        double adjustedLevel = this.checkIndex(fractionalIndex, sample.size(), true);
        double[] order = this.createIndexArray(sample.size());
        double[] s = sample.toArray();
        DoubleArrayMath.sortPairs((double[])s, (double[])order);
        int lowerIndex = (int)Math.floor(adjustedLevel);
        int upperIndex = (int)Math.ceil(adjustedLevel);
        int[] indices = new int[upperIndex];
        double[] weights = new double[upperIndex];
        double interval = 1.0 / (double)sampleSize;
        weights[0] = interval * (Math.min(fractionalIndex, 1.0) - this.indexCorrection());
        double losses = s[0] * weights[0];
        for (int i = 0; i < lowerIndex - 1; ++i) {
            losses += 0.5 * (s[i] + s[i + 1]) * interval;
            indices[i] = (int)order[i];
            int n = i;
            weights[n] = weights[n] + 0.5 * interval;
            int n2 = i + 1;
            weights[n2] = weights[n2] + 0.5 * interval;
        }
        if (lowerIndex != upperIndex) {
            double lowerWeight = (double)upperIndex - adjustedLevel;
            double upperWeight = 1.0 - lowerWeight;
            double quantile = lowerWeight * s[lowerIndex - 1] + upperWeight * s[upperIndex - 1];
            losses += 0.5 * (s[lowerIndex - 1] + quantile) * interval * upperWeight;
            indices[lowerIndex - 1] = (int)order[lowerIndex - 1];
            indices[upperIndex - 1] = (int)order[upperIndex - 1];
            int n = lowerIndex - 1;
            weights[n] = weights[n] + 0.5 * (1.0 + lowerWeight) * interval * upperWeight;
            weights[upperIndex - 1] = 0.5 * upperWeight * interval * upperWeight;
        }
        if (fractionalIndex > (double)sample.size()) {
            losses += s[sample.size() - 1] * (fractionalIndex - (double)sample.size()) * interval;
            indices[sample.size() - 1] = (int)order[sample.size() - 1];
            int n = sample.size() - 1;
            weights[n] = weights[n] + (fractionalIndex - (double)sample.size()) * interval;
        }
        return QuantileResult.of(losses / level, indices, DoubleArray.ofUnsafe((double[])weights).dividedBy(level));
    }

    abstract double indexCorrection();

    abstract int sampleCorrection(int var1);

    private double[] createIndexArray(int indexArrayLength) {
        double[] indexArray = new double[indexArrayLength];
        for (int i = 0; i < indexArrayLength; ++i) {
            indexArray[i] = i;
        }
        return indexArray;
    }
}

