/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import java.util.Arrays;
import java.util.function.Function;

public class MedianCalculator
implements Function<double[], Double> {
    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length > 0 ? 1 : 0) != 0, (String)"x cannot be empty");
        if (x.length == 1) {
            return x[0];
        }
        double[] x1 = Arrays.copyOf(x, x.length);
        Arrays.sort(x1);
        int mid = x1.length / 2;
        if (x1.length % 2 == 1) {
            return x1[mid];
        }
        return (x1[mid] + x1[mid - 1]) / 2.0;
    }
}

