/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.function.Function;

public class ModeCalculator
implements Function<double[], Double> {
    private static final double EPS = 1.0E-16;

    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length > 0 ? 1 : 0) != 0, (String)"x cannot be empty");
        if (x.length == 1) {
            return x[0];
        }
        double[] x1 = Arrays.copyOf(x, x.length);
        Arrays.sort(x1);
        TreeMap<Integer, Double> counts = new TreeMap<Integer, Double>();
        int count = 1;
        for (int i = 1; i < x1.length; ++i) {
            if (Math.abs(x1[i] - x1[i - 1]) < 1.0E-16) {
                ++count;
                continue;
            }
            counts.put(count, x1[i - 1]);
            count = 1;
        }
        if ((Integer)counts.lastKey() == 1) {
            throw new MathException("Could not find mode for array; no repeated values");
        }
        return (Double)counts.lastEntry().getValue();
    }
}

