/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import java.util.Arrays;
import java.util.function.Function;

public class PercentileCalculator
implements Function<double[], Double> {
    private double _percentile;

    public PercentileCalculator(double percentile) {
        ArgChecker.isTrue((percentile > 0.0 && percentile < 1.0 ? 1 : 0) != 0, (String)"Percentile must be between 0 and 1");
        this._percentile = percentile;
    }

    public void setPercentile(double percentile) {
        ArgChecker.isTrue((percentile > 0.0 && percentile < 1.0 ? 1 : 0) != 0, (String)"Percentile must be between 0 and 1");
        this._percentile = percentile;
    }

    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length > 0 ? 1 : 0) != 0, (String)"x cannot be empty");
        int length = x.length;
        double[] copy = Arrays.copyOf(x, length);
        Arrays.sort(copy);
        double n = this._percentile * (double)(length - 1) + 1.0;
        if (Math.round(n) == 1L) {
            return copy[0];
        }
        if (Math.round(n) == (long)length) {
            return copy[length - 1];
        }
        double d = n % 1.0;
        int k = (int)Math.round(n - d);
        return copy[k - 1] + d * (copy[k] - copy[k - 1]);
    }
}

