/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.descriptive.SampleVarianceCalculator;
import java.util.function.Function;

public class PopulationVarianceCalculator
implements Function<double[], Double> {
    private final Function<double[], Double> _variance = new SampleVarianceCalculator();

    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        int n = x.length;
        ArgChecker.isTrue((n >= 2 ? 1 : 0) != 0, (String)"Need at least two points to calculate the population variance");
        return this._variance.apply(x) * (double)(n - 1) / (double)n;
    }
}

