/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileResult;

public abstract class QuantileCalculationMethod {
    public QuantileResult quantileResultFromUnsorted(double level, DoubleArray sample) {
        return this.quantile(level, sample, false);
    }

    public QuantileResult quantileResultWithExtrapolationFromUnsorted(double level, DoubleArray sample) {
        return this.quantile(level, sample, true);
    }

    public double quantileFromSorted(double level, DoubleArray sortedSample) {
        return this.quantileResultFromUnsorted(level, sortedSample).getValue();
    }

    public double quantileFromUnsorted(double level, DoubleArray sample) {
        return this.quantileFromSorted(level, sample.sorted());
    }

    public double quantileWithExtrapolationFromSorted(double level, DoubleArray sortedSample) {
        return this.quantileResultWithExtrapolationFromUnsorted(level, sortedSample).getValue();
    }

    public double quantileWithExtrapolationFromUnsorted(double level, DoubleArray sample) {
        return this.quantileWithExtrapolationFromSorted(level, sample.sorted());
    }

    public QuantileResult expectedShortfallResultFromUnsorted(double level, DoubleArray sample) {
        return this.expectedShortfall(level, sample);
    }

    public double expectedShortfallFromSorted(double level, DoubleArray sortedSample) {
        return this.expectedShortfallResultFromUnsorted(level, sortedSample).getValue();
    }

    public double expectedShortfallFromUnsorted(double level, DoubleArray sample) {
        return this.expectedShortfallFromSorted(level, sample.sorted());
    }

    protected abstract QuantileResult quantile(double var1, DoubleArray var3, boolean var4);

    protected abstract QuantileResult expectedShortfall(double var1, DoubleArray var3);

    protected double checkIndex(double index, int size, boolean isExtrapolated) {
        if (isExtrapolated) {
            return Math.min(Math.max(index, 1.0), (double)size);
        }
        ArgChecker.isTrue((index >= 1.0 ? 1 : 0) != 0, (String)"Quantile can not be computed below the lowest probability level.");
        ArgChecker.isTrue((index <= (double)size ? 1 : 0) != 0, (String)"Quantile can not be computed above the highest probability level.");
        return index;
    }
}

