/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.array.DoubleArray;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class QuantileResult
implements ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double value;
    @PropertyDefinition
    private final int[] indices;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray weights;
    private static final long serialVersionUID = 1L;

    public static QuantileResult of(double value, int[] indices, DoubleArray weights) {
        return new QuantileResult(value, indices, weights);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private QuantileResult(double value, int[] indices, DoubleArray weights) {
        JodaBeanUtils.notNull((Object)weights, (String)"weights");
        this.value = value;
        this.indices = indices != null ? (int[])indices.clone() : null;
        this.weights = weights;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getValue() {
        return this.value;
    }

    public int[] getIndices() {
        return this.indices != null ? (int[])this.indices.clone() : null;
    }

    public DoubleArray getWeights() {
        return this.weights;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            QuantileResult other = (QuantileResult)obj;
            return JodaBeanUtils.equal((double)this.value, (double)other.value) && JodaBeanUtils.equal((Object)this.indices, (Object)other.indices) && JodaBeanUtils.equal((Object)this.weights, (Object)other.weights);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.indices);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.weights);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("QuantileResult{");
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
        buf.append("indices").append('=').append(JodaBeanUtils.toString((Object)this.indices)).append(',').append(' ');
        buf.append("weights").append('=').append(JodaBeanUtils.toString((Object)this.weights));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<QuantileResult> {
        private double value;
        private int[] indices;
        private DoubleArray weights;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 1943391143: {
                    return this.indices;
                }
                case 1230441723: {
                    return this.weights;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = (Double)newValue;
                    break;
                }
                case 1943391143: {
                    this.indices = (int[])newValue;
                    break;
                }
                case 1230441723: {
                    this.weights = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public QuantileResult build() {
            return new QuantileResult(this.value, this.indices, this.weights);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("QuantileResult.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value)).append(',').append(' ');
            buf.append("indices").append('=').append(JodaBeanUtils.toString((Object)this.indices)).append(',').append(' ');
            buf.append("weights").append('=').append(JodaBeanUtils.toString((Object)this.weights));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", QuantileResult.class, Double.TYPE);
        private final MetaProperty<int[]> indices = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indices", QuantileResult.class, int[].class);
        private final MetaProperty<DoubleArray> weights = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"weights", QuantileResult.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "indices", "weights"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 1943391143: {
                    return this.indices;
                }
                case 1230441723: {
                    return this.weights;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends QuantileResult> builder() {
            return new Builder();
        }

        public Class<? extends QuantileResult> beanType() {
            return QuantileResult.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> value() {
            return this.value;
        }

        public MetaProperty<int[]> indices() {
            return this.indices;
        }

        public MetaProperty<DoubleArray> weights() {
            return this.weights;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((QuantileResult)bean).getValue();
                }
                case 1943391143: {
                    return ((QuantileResult)bean).getIndices();
                }
                case 1230441723: {
                    return ((QuantileResult)bean).getWeights();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

