/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.descriptive.MeanCalculator;
import java.util.function.Function;

public class SampleFisherKurtosisCalculator
implements Function<double[], Double> {
    private static final Function<double[], Double> MEAN = new MeanCalculator();

    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length >= 4 ? 1 : 0) != 0, (String)"Need at least four points to calculate kurtosis");
        double sum = 0.0;
        double mean = MEAN.apply(x);
        double variance = 0.0;
        double[] dArray = x;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray[i];
            double diff = d - mean;
            double diffSq = diff * diff;
            variance += diffSq;
            sum += diffSq * diffSq;
        }
        int n2 = x.length;
        double n1 = n2 - 1;
        double n22 = n1 - 1.0;
        return (double)n2 * ((double)n2 + 1.0) * sum / (n1 * n22 * ((double)n2 - 3.0) * (variance /= n1) * variance) - 3.0 * n1 * n1 / (n22 * ((double)n2 - 3.0));
    }
}

