/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.descriptive.MeanCalculator;
import java.util.function.Function;

public class SampleVarianceCalculator
implements Function<double[], Double> {
    private static final Function<double[], Double> MEAN = new MeanCalculator();

    @Override
    public Double apply(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length >= 2 ? 1 : 0) != 0, (String)"Need at least two points to calculate the sample variance");
        Double mean = MEAN.apply(x);
        double sum = 0.0;
        for (double value : x) {
            double diff = value - mean;
            sum += diff * diff;
        }
        int n = x.length;
        return sum / (double)(n - 1);
    }
}

