/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;

public class BivariateNormalDistribution
implements ProbabilityDistribution<double[]> {
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double TWO_PI = Math.PI * 2;
    private static final double[] X = new double[]{0.04691008, 0.23076534, 0.5, 0.76923466, 0.95308992};
    private static final double[] Y = new double[]{0.018854042, 0.038088059, 0.0452707394, 0.038088059, 0.018854042};

    @Override
    public double getCDF(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length == 3 ? 1 : 0) != 0, (String)"Need a, b and rho values");
        ArgChecker.isTrue((x[2] >= -1.0 && x[2] <= 1.0 ? 1 : 0) != 0, (String)"Correlation must be >= -1 and <= 1");
        double a = x[0];
        double b = x[1];
        double rho = x[2];
        if (a == Double.POSITIVE_INFINITY || b == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (a == Double.NEGATIVE_INFINITY || b == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double sumSq = (a * a + b * b) / 2.0;
        double mult = 0.0;
        if (Math.abs(rho) >= 0.7) {
            double rho1 = 1.0 - rho * rho;
            double rho2 = Math.sqrt(rho1);
            if (rho < 0.0) {
                b *= -1.0;
            }
            double ab = a * b;
            double eab = Math.exp(-ab / 2.0);
            if (Math.abs(rho) < 1.0) {
                double absDiff = Math.abs(a - b);
                double h5 = absDiff * absDiff / 2.0;
                double c = 0.5 - ab / 8.0;
                double d = 3.0 - 2.0 * c * h5;
                mult = 0.13298076 * (absDiff /= rho2) * d * (1.0 - NORMAL.getCDF(absDiff)) - Math.exp(-h5 / rho1) * (d + c * rho1) * 0.053051647;
                for (int i = 0; i < 5; ++i) {
                    double rho3 = rho2 * X[i];
                    double rho3Sq = rho3 * rho3;
                    rho1 = Math.sqrt(1.0 - rho3Sq);
                    double e = eab == 0.0 ? 0.0 : Math.exp(-ab / (1.0 + rho1)) / rho1 / eab;
                    mult -= Y[i] * Math.exp(-h5 / rho3Sq) * (e - 1.0 - c * rho3Sq);
                }
            }
            double corr = Double.isNaN(mult) ? 0.0 : mult * rho2 * eab;
            double result = corr + NORMAL.getCDF(Math.min(a, b));
            if (rho < 0.0) {
                result = NORMAL.getCDF(a) - result;
            }
            return result;
        }
        double ab = a * b;
        if (rho != 0.0) {
            for (int i = 0; i < 5; ++i) {
                double rho3 = rho * X[i];
                double rho1 = 1.0 - rho3 * rho3;
                mult += Y[i] * Math.exp((rho3 * ab - sumSq) / rho1) / Math.sqrt(rho1);
            }
        }
        double corr = Double.isNaN(mult) ? 0.0 : rho * mult;
        return NORMAL.getCDF(a) * NORMAL.getCDF(b) + corr;
    }

    @Override
    public double getInverseCDF(double[] p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPDF(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.isTrue((x.length == 3 ? 1 : 0) != 0, (String)"Need a, b and rho values");
        ArgChecker.isTrue((x[2] >= -1.0 && x[2] <= 1.0 ? 1 : 0) != 0, (String)"Correlation must be >= -1 and <= 1");
        double denom = 1.0 - x[2] * x[2];
        return Math.exp(-(x[0] * x[0] - 2.0 * x[2] * x[0] * x[1] + x[1] * x[1]) / (2.0 * denom)) / (Math.PI * 2 * Math.sqrt(denom));
    }

    @Override
    public double nextRandom() {
        throw new UnsupportedOperationException();
    }
}

