/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.ChiSquare;
import com.opengamma.strata.math.impl.cern.MersenneTwister64;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.function.special.InverseIncompleteGammaFunction;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.Date;
import java.util.function.DoubleBinaryOperator;

public class ChiSquareDistribution
implements ProbabilityDistribution<Double> {
    private final DoubleBinaryOperator _inverseFunction = new InverseIncompleteGammaFunction();
    private final ChiSquare _chiSquare;
    private final double _degrees;

    public ChiSquareDistribution(double degrees) {
        this(degrees, new MersenneTwister64(new Date()));
    }

    public ChiSquareDistribution(double degrees, RandomEngine engine) {
        ArgChecker.isTrue((degrees >= 1.0 ? 1 : 0) != 0, (String)"Degrees of freedom must be greater than or equal to one");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._chiSquare = new ChiSquare(degrees, engine);
        this._degrees = degrees;
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._chiSquare.cdf(x);
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._chiSquare.pdf(x);
    }

    @Override
    public double getInverseCDF(Double p) {
        ArgChecker.notNull((Object)p, (String)"p");
        ArgChecker.isTrue((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Probability must lie between 0 and 1");
        return 2.0 * this._inverseFunction.applyAsDouble(0.5 * this._degrees, p);
    }

    @Override
    public double nextRandom() {
        return this._chiSquare.nextDouble();
    }

    public double getDegreesOfFreedom() {
        return this._degrees;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._degrees);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChiSquareDistribution other = (ChiSquareDistribution)obj;
        return Double.doubleToLongBits(this._degrees) == Double.doubleToLongBits(other._degrees);
    }
}

