/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.statistics.distribution.D1MACH;

final class DCSEVL {
    private static double ONEPL = 1.0 + D1MACH.four();

    static double compute(double x, double[] cs, int n) {
        if (cs == null) {
            throw new MathException("DCSEVL: cs is null");
        }
        if (n < 1) {
            throw new MathException("DCSEVL: number of terms < 0");
        }
        if (n > 1000) {
            throw new MathException("DCSEVL: number of terms > 1000");
        }
        if (Math.abs(x) > ONEPL) {
            throw new MathException("DCSEVL: x outside of the interval [-1,+1)");
        }
        if (n > cs.length) {
            throw new MathException("DCSEVL: number of terms to compute greater than number of coefficients given (n>cs.length)");
        }
        double b2 = 0.0;
        double b1 = 0.0;
        double b0 = 0.0;
        double twoX = 2.0 * x;
        for (int i = 0; i < n; ++i) {
            b2 = b1;
            b1 = b0;
            int ni = n - 1 - i;
            b0 = twoX * b1 - b2 + cs[ni];
        }
        return 0.5 * (b0 - b2);
    }

    private DCSEVL() {
    }
}

