/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;

public class GeneralizedExtremeValueDistribution
implements ProbabilityDistribution<Double> {
    private final double _mu;
    private final double _sigma;
    private final double _ksi;
    private final boolean _ksiIsZero;

    public GeneralizedExtremeValueDistribution(double mu, double sigma, double ksi) {
        ArgChecker.isTrue((sigma >= 0.0 ? 1 : 0) != 0, (String)"sigma must be >= 0");
        this._mu = mu;
        this._sigma = sigma;
        this._ksi = ksi;
        this._ksiIsZero = DoubleMath.fuzzyEquals((double)ksi, (double)0.0, (double)1.0E-13);
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return Math.exp(-this.getT(x));
    }

    @Override
    public double getInverseCDF(Double p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        double t = this.getT(x);
        return Math.pow(t, this._ksi + 1.0) * Math.exp(-t) / this._sigma;
    }

    @Override
    public double nextRandom() {
        throw new UnsupportedOperationException();
    }

    public double getMu() {
        return this._mu;
    }

    public double getSigma() {
        return this._sigma;
    }

    public double getKsi() {
        return this._ksi;
    }

    private double getT(double x) {
        if (this._ksiIsZero) {
            return Math.exp(-(x - this._mu) / this._sigma);
        }
        if (this._ksi < 0.0 && x > this._mu - this._sigma / this._ksi) {
            throw new IllegalArgumentException("Support for GEV is in the range -infinity -> mu - sigma / ksi when ksi < 0");
        }
        if (this._ksi > 0.0 && x < this._mu - this._sigma / this._ksi) {
            throw new IllegalArgumentException("Support for GEV is in the range mu - sigma / ksi -> +infinity when ksi > 0");
        }
        return Math.pow(1.0 + this._ksi * (x - this._mu) / this._sigma, -1.0 / this._ksi);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._ksi);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._mu);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._sigma);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralizedExtremeValueDistribution other = (GeneralizedExtremeValueDistribution)obj;
        if (Double.doubleToLongBits(this._ksi) != Double.doubleToLongBits(other._ksi)) {
            return false;
        }
        if (Double.doubleToLongBits(this._mu) != Double.doubleToLongBits(other._mu)) {
            return false;
        }
        return Double.doubleToLongBits(this._sigma) == Double.doubleToLongBits(other._sigma);
    }
}

