/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.MersenneTwister64;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.Date;

public class GeneralizedParetoDistribution
implements ProbabilityDistribution<Double> {
    private final double _mu;
    private final double _sigma;
    private final double _ksi;
    private final RandomEngine _engine;

    public GeneralizedParetoDistribution(double mu, double sigma, double ksi) {
        this(mu, sigma, ksi, new MersenneTwister64(new Date()));
    }

    public GeneralizedParetoDistribution(double mu, double sigma, double ksi, RandomEngine engine) {
        ArgChecker.isTrue((sigma > 0.0 ? 1 : 0) != 0, (String)"sigma must be > 0");
        ArgChecker.isTrue((!DoubleMath.fuzzyEquals((double)ksi, (double)0.0, (double)1.0E-15) ? 1 : 0) != 0, (String)"ksi cannot be zero");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._mu = mu;
        this._sigma = sigma;
        this._ksi = ksi;
        this._engine = engine;
    }

    public double getMu() {
        return this._mu;
    }

    public double getSigma() {
        return this._sigma;
    }

    public double getKsi() {
        return this._ksi;
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return 1.0 - Math.pow(1.0 + this._ksi * this.getZ(x), -1.0 / this._ksi);
    }

    @Override
    public double getInverseCDF(Double p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return Math.pow(1.0 + this._ksi * this.getZ(x), -(1.0 / this._ksi + 1.0)) / this._sigma;
    }

    @Override
    public double nextRandom() {
        return this._mu + this._sigma * (Math.pow(this._engine.nextDouble(), -this._ksi) - 1.0) / this._ksi;
    }

    private double getZ(double x) {
        if (this._ksi > 0.0 && x < this._mu) {
            throw new IllegalArgumentException("Support for GPD is in the range x >= mu if ksi > 0");
        }
        if (this._ksi < 0.0 && (x <= this._mu || x >= this._mu - this._sigma / this._ksi)) {
            throw new IllegalArgumentException("Support for GPD is in the range mu <= x <= mu - sigma / ksi if ksi < 0");
        }
        return (x - this._mu) / this._sigma;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._ksi);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._mu);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._sigma);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralizedParetoDistribution other = (GeneralizedParetoDistribution)obj;
        if (Double.doubleToLongBits(this._ksi) != Double.doubleToLongBits(other._ksi)) {
            return false;
        }
        if (Double.doubleToLongBits(this._mu) != Double.doubleToLongBits(other._mu)) {
            return false;
        }
        return Double.doubleToLongBits(this._sigma) == Double.doubleToLongBits(other._sigma);
    }
}

