/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.MersenneTwister64;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.Date;

public class LaplaceDistribution
implements ProbabilityDistribution<Double> {
    private final RandomEngine _engine;
    private final double _mu;
    private final double _b;

    public LaplaceDistribution(double mu, double b) {
        this(mu, b, new MersenneTwister64(new Date()));
    }

    public LaplaceDistribution(double mu, double b, RandomEngine engine) {
        ArgChecker.isTrue((b > 0.0 ? 1 : 0) != 0, (String)"b must be > 0");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._mu = mu;
        this._b = b;
        this._engine = engine;
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return 0.5 * (1.0 + Math.signum(x - this._mu) * (1.0 - Math.exp(-Math.abs(x - this._mu) / this._b)));
    }

    @Override
    public double getInverseCDF(Double p) {
        ArgChecker.notNull((Object)p, (String)"p");
        ArgChecker.isTrue((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Probability must lie between 0 and 1 (inclusive)");
        return this._mu - this._b * Math.signum(p - 0.5) * Math.log(1.0 - 2.0 * Math.abs(p - 0.5));
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return Math.exp(-Math.abs(x - this._mu) / this._b) / (2.0 * this._b);
    }

    @Override
    public double nextRandom() {
        double u = this._engine.nextDouble() - 0.5;
        return this._mu - this._b * Math.signum(u) * Math.log(1.0 - 2.0 * Math.abs(u));
    }

    public double getMu() {
        return this._mu;
    }

    public double getB() {
        return this._b;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._b);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._mu);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaplaceDistribution other = (LaplaceDistribution)obj;
        if (Double.doubleToLongBits(this._b) != Double.doubleToLongBits(other._b)) {
            return false;
        }
        return Double.doubleToLongBits(this._mu) == Double.doubleToLongBits(other._mu);
    }
}

