/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.special.Gamma;

public class NonCentralChiSquaredDistribution
implements ProbabilityDistribution<Double> {
    private final double _lambdaOverTwo;
    private final int _k;
    private final double _dofOverTwo;
    private final double _pStart;
    private final double _eps = 1.0E-16;

    public NonCentralChiSquaredDistribution(double degrees, double nonCentrality) {
        ArgChecker.isTrue((degrees > 0.0 ? 1 : 0) != 0, (String)("degrees of freedom must be > 0, have " + degrees));
        ArgChecker.isTrue((nonCentrality >= 0.0 ? 1 : 0) != 0, (String)("non-centrality must be >= 0, have " + nonCentrality));
        this._dofOverTwo = degrees / 2.0;
        this._lambdaOverTwo = nonCentrality / 2.0;
        this._k = (int)Math.round(this._lambdaOverTwo);
        if (this._lambdaOverTwo == 0.0) {
            this._pStart = 0.0;
        } else {
            double logP = -this._lambdaOverTwo + (double)this._k * Math.log(this._lambdaOverTwo) - Gamma.logGamma((double)(this._k + 1));
            this._pStart = Math.exp(logP);
        }
    }

    private double getFraserApproxCDF(double x) {
        double s = Math.sqrt(this._lambdaOverTwo * 2.0);
        double mu = Math.sqrt(x);
        double z = Double.doubleToLongBits(mu) == Double.doubleToLongBits(s) ? (1.0 - this._dofOverTwo * 2.0) / 2.0 / s : mu - s - (this._dofOverTwo * 2.0 - 1.0) / 2.0 * (Math.log(mu) - Math.log(s)) / (mu - s);
        return new NormalDistribution(0.0, 1.0).getCDF(z);
    }

    @Override
    public double getCDF(Double x) {
        double temp;
        ArgChecker.notNull((Object)x, (String)"x");
        if (x < 0.0) {
            return 0.0;
        }
        if (this._dofOverTwo + this._lambdaOverTwo > 1000.0) {
            return this.getFraserApproxCDF(x);
        }
        double regGammaStart = 0.0;
        double halfX = x / 2.0;
        double logX = Math.log(halfX);
        try {
            regGammaStart = Gamma.regularizedGammaP((double)(this._dofOverTwo + (double)this._k), (double)halfX);
        }
        catch (MaxCountExceededException ex) {
            throw new MathException(ex);
        }
        double sum = this._pStart * regGammaStart;
        double oldSum = Double.NEGATIVE_INFINITY;
        double p = this._pStart;
        double regGamma = regGammaStart;
        int i = this._k;
        while (i > 0 && Math.abs(sum - oldSum) / sum > 1.0E-16) {
            temp = (this._dofOverTwo + (double)i) * logX - halfX - Gamma.logGamma((double)(this._dofOverTwo + (double)i + 1.0));
            oldSum = sum;
            sum += (p *= (double)(--i + 1) / this._lambdaOverTwo) * (regGamma += Math.exp(temp));
        }
        p = this._pStart;
        regGamma = regGammaStart;
        oldSum = Double.NEGATIVE_INFINITY;
        i = this._k;
        while (Math.abs(sum - oldSum) / sum > 1.0E-16) {
            temp = (this._dofOverTwo + (double)i - 1.0) * logX - halfX - Gamma.logGamma((double)(this._dofOverTwo + (double)i));
            oldSum = sum;
            sum += (p *= this._lambdaOverTwo / (double)(++i)) * (regGamma -= Math.exp(temp));
        }
        return sum;
    }

    @Override
    public double getInverseCDF(Double p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getPDF(Double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double nextRandom() {
        throw new UnsupportedOperationException();
    }

    public double getDegrees() {
        return this._dofOverTwo * 2.0;
    }

    public double getNonCentrality() {
        return this._lambdaOverTwo * 2.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._dofOverTwo);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._lambdaOverTwo);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonCentralChiSquaredDistribution other = (NonCentralChiSquaredDistribution)obj;
        if (Double.doubleToLongBits(this._dofOverTwo) != Double.doubleToLongBits(other._dofOverTwo)) {
            return false;
        }
        return Double.doubleToLongBits(this._lambdaOverTwo) == Double.doubleToLongBits(other._lambdaOverTwo);
    }
}

