/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.MersenneTwister64;
import com.opengamma.strata.math.impl.cern.Normal;
import com.opengamma.strata.math.impl.cern.Probability;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.statistics.distribution.DERFC;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.Date;

public class NormalDistribution
implements ProbabilityDistribution<Double> {
    private static final double ROOT2 = Math.sqrt(2.0);
    private final double _mean;
    private final double _standardDeviation;
    private final Normal _normal;

    public NormalDistribution(double mean, double standardDeviation) {
        this(mean, standardDeviation, new MersenneTwister64(new Date()));
    }

    public NormalDistribution(double mean, double standardDeviation, RandomEngine randomEngine) {
        ArgChecker.isTrue((standardDeviation > 0.0 ? 1 : 0) != 0, (String)"standard deviation");
        ArgChecker.notNull((Object)randomEngine, (String)"randomEngine");
        this._mean = mean;
        this._standardDeviation = standardDeviation;
        this._normal = new Normal(mean, standardDeviation, randomEngine);
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return DERFC.getErfc(-x.doubleValue() / ROOT2) / 2.0;
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._normal.pdf(x);
    }

    @Override
    public double nextRandom() {
        return this._normal.nextDouble();
    }

    @Override
    public double getInverseCDF(Double p) {
        ArgChecker.notNull((Object)p, (String)"p");
        ArgChecker.isTrue((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Probability must be >= 0 and <= 1");
        return Probability.normalInverse(p);
    }

    public double getMean() {
        return this._mean;
    }

    public double getStandardDeviation() {
        return this._standardDeviation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._mean);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._standardDeviation);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NormalDistribution other = (NormalDistribution)obj;
        if (Double.doubleToLongBits(this._mean) != Double.doubleToLongBits(other._mean)) {
            return false;
        }
        return Double.doubleToLongBits(this._standardDeviation) == Double.doubleToLongBits(other._standardDeviation);
    }
}

