/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.MersenneTwister64;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.cern.StudentT;
import com.opengamma.strata.math.impl.function.special.InverseIncompleteBetaFunction;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import java.util.Date;
import java.util.function.Function;

public class StudentTDistribution
implements ProbabilityDistribution<Double> {
    private final double _degFreedom;
    private final StudentT _dist;
    private final Function<Double, Double> _beta;

    public StudentTDistribution(double degFreedom) {
        this(degFreedom, new MersenneTwister64(new Date()));
    }

    public StudentTDistribution(double degFreedom, RandomEngine engine) {
        ArgChecker.isTrue((degFreedom > 0.0 ? 1 : 0) != 0, (String)"degrees of freedom");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._degFreedom = degFreedom;
        this._dist = new StudentT(degFreedom, engine);
        this._beta = new InverseIncompleteBetaFunction(degFreedom / 2.0, 0.5);
    }

    @Override
    public double getCDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._dist.cdf(x);
    }

    @Override
    public double getPDF(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        return this._dist.pdf(x);
    }

    @Override
    public double nextRandom() {
        return this._dist.nextDouble();
    }

    @Override
    public double getInverseCDF(Double p) {
        ArgChecker.notNull((Object)p, (String)"p");
        ArgChecker.isTrue((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Probability must be >= 0 and <= 1");
        double x = this._beta.apply(2.0 * Math.min(p, 1.0 - p));
        return Math.signum(p - 0.5) * Math.sqrt(this._degFreedom * (1.0 / x - 1.0));
    }

    public double getDegreesOfFreedom() {
        return this._degFreedom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this._degFreedom);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StudentTDistribution other = (StudentTDistribution)obj;
        return Double.doubleToLongBits(this._degFreedom) == Double.doubleToLongBits(other._degFreedom);
    }
}

