/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.StudentTDistribution;
import java.util.function.Function;

public class StudentTOneTailedCriticalValueCalculator
implements Function<Double, Double> {
    private final ProbabilityDistribution<Double> _dist;

    public StudentTOneTailedCriticalValueCalculator(double nu) {
        ArgChecker.notNegative((double)nu, (String)"nu");
        this._dist = new StudentTDistribution(nu);
    }

    public StudentTOneTailedCriticalValueCalculator(double nu, RandomEngine engine) {
        ArgChecker.notNegative((double)nu, (String)"nu");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._dist = new StudentTDistribution(nu, engine);
    }

    @Override
    public Double apply(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.notNegative((double)x, (String)"x");
        if (DoubleMath.fuzzyEquals((double)x, (double)0.5, (double)1.0E-14)) {
            return 0.5;
        }
        return this._dist.getInverseCDF(x);
    }
}

