/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.distribution;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.cern.RandomEngine;
import com.opengamma.strata.math.impl.statistics.distribution.StudentTOneTailedCriticalValueCalculator;
import java.util.function.Function;

public class StudentTTwoTailedCriticalValueCalculator
implements Function<Double, Double> {
    private final Function<Double, Double> _calc;

    public StudentTTwoTailedCriticalValueCalculator(double nu) {
        ArgChecker.notNegative((double)nu, (String)"nu");
        this._calc = new StudentTOneTailedCriticalValueCalculator(nu);
    }

    public StudentTTwoTailedCriticalValueCalculator(double nu, RandomEngine engine) {
        ArgChecker.notNegative((double)nu, (String)"nu");
        ArgChecker.notNull((Object)engine, (String)"engine");
        this._calc = new StudentTOneTailedCriticalValueCalculator(nu, engine);
    }

    @Override
    public Double apply(Double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        ArgChecker.notNegative((double)x, (String)"x");
        return this._calc.apply(0.5 + 0.5 * x);
    }
}

