/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.leastsquare;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.BasisFunctionAggregation;
import com.opengamma.strata.math.impl.statistics.leastsquare.LeastSquareResults;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class GeneralizedLeastSquareResults<T>
extends LeastSquareResults {
    private final Function<T, Double> _function;

    public GeneralizedLeastSquareResults(List<Function<T, Double>> basisFunctions, double chiSq, DoubleArray parameters, DoubleMatrix covariance) {
        super(chiSq, parameters, covariance, null);
        this._function = new BasisFunctionAggregation<T>(basisFunctions, parameters.toArray());
    }

    public Function<T, Double> getFunction() {
        return this._function;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this._function.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GeneralizedLeastSquareResults)) {
            return false;
        }
        GeneralizedLeastSquareResults other = (GeneralizedLeastSquareResults)obj;
        return Objects.equals(this._function, other._function);
    }
}

