/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.util;

import com.opengamma.strata.collect.ArgChecker;

public class Diff {
    public static double[] values(double[] v) {
        ArgChecker.notNull((Object)v, (String)"v");
        int n = v.length - 1;
        double[] tmp = new double[n];
        for (int i = 0; i < n; ++i) {
            tmp[i] = v[i + 1] - v[i];
        }
        return tmp;
    }

    public static double[] values(double[] v, int t) {
        double[] tmp;
        ArgChecker.notNull((Object)v, (String)"v");
        ArgChecker.isTrue((t > -1 ? 1 : 0) != 0, (String)"Invalid number of differences requested, t must be positive or 0, but was {}", (long)t);
        ArgChecker.isTrue((t < v.length ? 1 : 0) != 0, (String)"Invalid number of differences requested, 't' is greater than the number of elements in 'v'. The given 't' was: {} and 'v' contains {} elements", (Object[])new Object[]{t, v.length});
        if (t == 0) {
            tmp = new double[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
        } else {
            tmp = Diff.values(v);
            for (int i = 0; i < t - 1; ++i) {
                tmp = Diff.values(tmp);
            }
        }
        return tmp;
    }

    public static float[] values(float[] v) {
        ArgChecker.notNull((Object)v, (String)"v");
        int n = v.length - 1;
        float[] tmp = new float[n];
        for (int i = 0; i < n; ++i) {
            tmp[i] = v[i + 1] - v[i];
        }
        return tmp;
    }

    public static float[] values(float[] v, int t) {
        float[] tmp;
        ArgChecker.notNull((Object)v, (String)"v");
        ArgChecker.isTrue((t > -1 ? 1 : 0) != 0, (String)"Invalid number of differences requested, t must be positive or 0, but was {}", (long)t);
        ArgChecker.isTrue((t < v.length ? 1 : 0) != 0, (String)"Invalid number of differences requested, 't' is greater than the number of elements in 'v'. The given 't' was: {} and 'v' contains {} elements", (Object[])new Object[]{t, v.length});
        if (t == 0) {
            tmp = new float[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
        } else {
            tmp = Diff.values(v);
            for (int i = 0; i < t - 1; ++i) {
                tmp = Diff.values(tmp);
            }
        }
        return tmp;
    }

    public static int[] values(int[] v) {
        ArgChecker.notNull((Object)v, (String)"v");
        int n = v.length - 1;
        int[] tmp = new int[n];
        for (int i = 0; i < n; ++i) {
            tmp[i] = v[i + 1] - v[i];
        }
        return tmp;
    }

    public static int[] values(int[] v, int t) {
        int[] tmp;
        ArgChecker.notNull((Object)v, (String)"v");
        ArgChecker.isTrue((t > -1 ? 1 : 0) != 0, (String)"Invalid number of differences requested, t must be positive or 0, but was {}", (long)t);
        ArgChecker.isTrue((t < v.length ? 1 : 0) != 0, (String)"Invalid number of differences requested, 't' is greater than the number of elements in 'v'. The given 't' was: {} and 'v' contains {} elements", (Object[])new Object[]{t, v.length});
        if (t == 0) {
            tmp = new int[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
        } else {
            tmp = Diff.values(v);
            for (int i = 0; i < t - 1; ++i) {
                tmp = Diff.values(tmp);
            }
        }
        return tmp;
    }

    public static long[] values(long[] v) {
        ArgChecker.notNull((Object)v, (String)"v");
        int n = v.length - 1;
        long[] tmp = new long[n];
        for (int i = 0; i < n; ++i) {
            tmp[i] = v[i + 1] - v[i];
        }
        return tmp;
    }

    public static long[] values(long[] v, int t) {
        long[] tmp;
        ArgChecker.notNull((Object)v, (String)"v");
        ArgChecker.isTrue((t > -1 ? 1 : 0) != 0, (String)"Invalid number of differences requested, t must be positive or 0, but was {}", (long)t);
        ArgChecker.isTrue((t < v.length ? 1 : 0) != 0, (String)"Invalid number of differences requested, 't' is greater than the number of elements in 'v'. The given 't' was: {} and 'v' contains {} elements", (Object[])new Object[]{t, v.length});
        if (t == 0) {
            tmp = new long[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
        } else {
            tmp = Diff.values(v);
            for (int i = 0; i < t - 1; ++i) {
                tmp = Diff.values(tmp);
            }
        }
        return tmp;
    }

    private Diff() {
    }
}

