/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.ComplexNumber;

public class ComplexMathUtils {
    public static ComplexNumber add(ComplexNumber z1, ComplexNumber z2) {
        ArgChecker.notNull((Object)z1, (String)"z1");
        ArgChecker.notNull((Object)z2, (String)"z2");
        return new ComplexNumber(z1.getReal() + z2.getReal(), z1.getImaginary() + z2.getImaginary());
    }

    public static ComplexNumber add(ComplexNumber ... z) {
        ArgChecker.notNull((Object)z, (String)"z");
        double res = 0.0;
        double img = 0.0;
        for (ComplexNumber aZ : z) {
            res += aZ.getReal();
            img += aZ.getImaginary();
        }
        return new ComplexNumber(res, img);
    }

    public static ComplexNumber add(ComplexNumber z, double x) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal() + x, z.getImaginary());
    }

    public static ComplexNumber add(double x, ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal() + x, z.getImaginary());
    }

    public static double arg(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return Math.atan2(z.getImaginary(), z.getReal());
    }

    public static ComplexNumber conjugate(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal(), -z.getImaginary());
    }

    public static ComplexNumber divide(ComplexNumber z1, ComplexNumber z2) {
        ArgChecker.notNull((Object)z1, (String)"z1");
        ArgChecker.notNull((Object)z2, (String)"z2");
        double a = z1.getReal();
        double b = z1.getImaginary();
        double c = z2.getReal();
        double d = z2.getImaginary();
        if (Math.abs(c) > Math.abs(d)) {
            double dOverC = d / c;
            double denom = c + d * dOverC;
            return new ComplexNumber((a + b * dOverC) / denom, (b - a * dOverC) / denom);
        }
        double cOverD = c / d;
        double denom = c * cOverD + d;
        return new ComplexNumber((a * cOverD + b) / denom, (b * cOverD - a) / denom);
    }

    public static ComplexNumber divide(ComplexNumber z, double x) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal() / x, z.getImaginary() / x);
    }

    public static ComplexNumber divide(double x, ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        double c = z.getReal();
        double d = z.getImaginary();
        if (Math.abs(c) > Math.abs(d)) {
            double dOverC = d / c;
            double denom = c + d * dOverC;
            return new ComplexNumber(x / denom, -x * dOverC / denom);
        }
        double cOverD = c / d;
        double denom = c * cOverD + d;
        return new ComplexNumber(x * cOverD / denom, -x / denom);
    }

    public static ComplexNumber exp(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        double mult = Math.exp(z.getReal());
        return new ComplexNumber(mult * Math.cos(z.getImaginary()), mult * Math.sin(z.getImaginary()));
    }

    public static ComplexNumber inverse(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        double c = z.getReal();
        double d = z.getImaginary();
        if (Math.abs(c) > Math.abs(d)) {
            double dOverC = d / c;
            double denom = c + d * dOverC;
            return new ComplexNumber(1.0 / denom, -dOverC / denom);
        }
        double cOverD = c / d;
        double denom = c * cOverD + d;
        return new ComplexNumber(cOverD / denom, -1.0 / denom);
    }

    public static ComplexNumber log(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(Math.log(Math.hypot(z.getReal(), z.getImaginary())), Math.atan2(z.getImaginary(), z.getReal()));
    }

    public static double mod(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return Math.hypot(z.getReal(), z.getImaginary());
    }

    public static ComplexNumber square(ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        double a = z.getReal();
        double b = z.getImaginary();
        return new ComplexNumber(a * a - b * b, 2.0 * a * b);
    }

    public static ComplexNumber multiply(ComplexNumber z1, ComplexNumber z2) {
        ArgChecker.notNull((Object)z1, (String)"z1");
        ArgChecker.notNull((Object)z2, (String)"z2");
        double a = z1.getReal();
        double b = z1.getImaginary();
        double c = z2.getReal();
        double d = z2.getImaginary();
        return new ComplexNumber(a * c - b * d, a * d + b * c);
    }

    public static ComplexNumber multiply(ComplexNumber ... z) {
        ArgChecker.notNull((Object)z, (String)"z");
        int n = z.length;
        ArgChecker.isTrue((n > 0 ? 1 : 0) != 0, (String)"nothing to multiply");
        if (n == 1) {
            return z[0];
        }
        if (n == 2) {
            return ComplexMathUtils.multiply(z[0], z[1]);
        }
        ComplexNumber product = ComplexMathUtils.multiply(z[0], z[1]);
        for (int i = 2; i < n; ++i) {
            product = ComplexMathUtils.multiply(product, z[i]);
        }
        return product;
    }

    public static ComplexNumber multiply(double x, ComplexNumber ... z) {
        ComplexNumber product = ComplexMathUtils.multiply(z);
        return ComplexMathUtils.multiply(x, product);
    }

    public static ComplexNumber multiply(ComplexNumber z, double x) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal() * x, z.getImaginary() * x);
    }

    public static ComplexNumber multiply(double x, ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal() * x, z.getImaginary() * x);
    }

    public static ComplexNumber pow(ComplexNumber z1, ComplexNumber z2) {
        ArgChecker.notNull((Object)z1, (String)"z1");
        ArgChecker.notNull((Object)z2, (String)"z2");
        double mod = ComplexMathUtils.mod(z1);
        double arg = ComplexMathUtils.arg(z1);
        double mult = Math.pow(mod, z2.getReal()) * Math.exp(-z2.getImaginary() * arg);
        double theta = z2.getReal() * arg + z2.getImaginary() * Math.log(mod);
        return new ComplexNumber(mult * Math.cos(theta), mult * Math.sin(theta));
    }

    public static ComplexNumber pow(ComplexNumber z, double x) {
        double mod = ComplexMathUtils.mod(z);
        double arg = ComplexMathUtils.arg(z);
        double mult = Math.pow(mod, x);
        return new ComplexNumber(mult * Math.cos(x * arg), mult * Math.sin(x * arg));
    }

    public static ComplexNumber pow(double x, ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return ComplexMathUtils.pow(new ComplexNumber(x, 0.0), z);
    }

    public static ComplexNumber sqrt(ComplexNumber z) {
        double w;
        ArgChecker.notNull((Object)z, (String)"z");
        double c = z.getReal();
        double d = z.getImaginary();
        if (c == 0.0 && d == 0.0) {
            return z;
        }
        if (Math.abs(c) > Math.abs(d)) {
            double dOverC = d / c;
            w = Math.sqrt(Math.abs(c)) * Math.sqrt((1.0 + Math.sqrt(1.0 + dOverC * dOverC)) / 2.0);
        } else {
            double cOverD = c / d;
            w = Math.sqrt(Math.abs(d)) * Math.sqrt((Math.abs(cOverD) + Math.sqrt(1.0 + cOverD * cOverD)) / 2.0);
        }
        if (c >= 0.0) {
            return new ComplexNumber(w, d / 2.0 / w);
        }
        if (d >= 0.0) {
            return new ComplexNumber(d / 2.0 / w, w);
        }
        return new ComplexNumber(-d / 2.0 / w, -w);
    }

    public static ComplexNumber subtract(ComplexNumber z1, ComplexNumber z2) {
        ArgChecker.notNull((Object)z1, (String)"z1");
        ArgChecker.notNull((Object)z2, (String)"z2");
        return new ComplexNumber(z1.getReal() - z2.getReal(), z1.getImaginary() - z2.getImaginary());
    }

    public static ComplexNumber subtract(ComplexNumber z, double x) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(z.getReal() - x, z.getImaginary());
    }

    public static ComplexNumber subtract(double x, ComplexNumber z) {
        ArgChecker.notNull((Object)z, (String)"z");
        return new ComplexNumber(x - z.getReal(), -z.getImaginary());
    }

    private ComplexMathUtils() {
    }
}

