/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl;

public class ComplexNumber
extends Number {
    public static final ComplexNumber I = new ComplexNumber(0.0, 1.0);
    public static final ComplexNumber MINUS_I = new ComplexNumber(0.0, -1.0);
    public static final ComplexNumber ZERO = new ComplexNumber(0.0);
    private static final long serialVersionUID = 1L;
    private final double real;
    private final double imaginary;

    public ComplexNumber(double real) {
        this.real = real;
        this.imaginary = 0.0;
    }

    public ComplexNumber(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException("Cannot get the doubleValue of a ComplexNumber");
    }

    @Override
    public float floatValue() {
        throw new UnsupportedOperationException("Cannot get the floatValue of a ComplexNumber");
    }

    @Override
    public int intValue() {
        throw new UnsupportedOperationException("Cannot get the intValue of a ComplexNumber");
    }

    @Override
    public long longValue() {
        throw new UnsupportedOperationException("Cannot get the longValue of a ComplexNumber");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexNumber other = (ComplexNumber)obj;
        if (Double.doubleToLongBits(this.imaginary) != Double.doubleToLongBits(other.imaginary)) {
            return false;
        }
        return Double.doubleToLongBits(this.real) == Double.doubleToLongBits(other.real);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.imaginary);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.real);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        boolean negative = this.imaginary < 0.0;
        double abs = Math.abs(this.imaginary);
        return Double.toString(this.real) + (negative ? " - " : " + ") + Double.toString(abs) + "i";
    }
}

