/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import java.util.Arrays;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    @Deprecated
    public static double square(double x) {
        return x * x;
    }

    @Deprecated
    public static double cube(double x) {
        return x * x * x;
    }

    public static int toTensorIndex(int[] indices, int[] dimensions) {
        ArgChecker.notNull((Object)indices, (String)"indices");
        ArgChecker.notNull((Object)dimensions, (String)"dimensions");
        int dim = indices.length;
        ArgChecker.isTrue((dim == dimensions.length ? 1 : 0) != 0);
        int sum = 0;
        int product = 1;
        for (int i = 0; i < dim; ++i) {
            ArgChecker.isTrue((indices[i] < dimensions[i] ? 1 : 0) != 0, (String)"index out of bounds");
            sum += indices[i] * product;
            product *= dimensions[i];
        }
        return sum;
    }

    public static int[] fromTensorIndex(int index, int[] dimensions) {
        ArgChecker.notNull((Object)dimensions, (String)"dimensions");
        int dim = dimensions.length;
        int[] res = new int[dim];
        int product = 1;
        int[] products = new int[dim - 1];
        for (int i = 0; i < dim - 1; ++i) {
            products[i] = product *= dimensions[i];
        }
        int a = index;
        for (int i = dim - 1; i > 0; --i) {
            res[i] = a / products[i - 1];
            a -= res[i] * products[i - 1];
        }
        res[0] = a;
        return res;
    }

    public static double[] unique(double[] in) {
        Arrays.sort(in);
        int n = in.length;
        double[] temp = new double[n];
        temp[0] = in[0];
        int count = 1;
        for (int i = 1; i < n; ++i) {
            if (Double.compare(in[i], in[i - 1]) == 0) continue;
            temp[count++] = in[i];
        }
        if (count == n) {
            return temp;
        }
        return Arrays.copyOf(temp, count);
    }

    public static int[] unique(int[] in) {
        Arrays.sort(in);
        int n = in.length;
        int[] temp = new int[n];
        temp[0] = in[0];
        int count = 1;
        for (int i = 1; i < n; ++i) {
            if (in[i] == in[i - 1]) continue;
            temp[count++] = in[i];
        }
        if (count == n) {
            return temp;
        }
        return Arrays.copyOf(in, count);
    }

    public static int getLowerBoundIndex(DoubleArray set, double value) {
        int n = set.size();
        if (value < set.get(0)) {
            return 0;
        }
        if (value > set.get(n - 1)) {
            return n - 1;
        }
        int index = Arrays.binarySearch(set.toArrayUnsafe(), value);
        if (index >= 0) {
            return index;
        }
        index = -(index + 1);
        if (value == -0.0 && --index < n - 1 && set.get(index + 1) == 0.0) {
            ++index;
        }
        return index;
    }
}

