/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.differentiation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.differentiation.Differentiator;
import com.opengamma.strata.math.impl.differentiation.FiniteDifferenceType;
import java.util.function.Function;

public class ScalarFieldFirstOrderDifferentiator
implements Differentiator<DoubleArray, Double, DoubleArray> {
    private static final double DEFAULT_EPS = 1.0E-5;
    private static final double MIN_EPS = Math.sqrt(Double.MIN_NORMAL);
    private final double eps;
    private final double twoEps;
    private final FiniteDifferenceType differenceType;

    public ScalarFieldFirstOrderDifferentiator() {
        this(FiniteDifferenceType.CENTRAL, 1.0E-5);
    }

    public ScalarFieldFirstOrderDifferentiator(FiniteDifferenceType differenceType, double eps) {
        ArgChecker.notNull((Object)((Object)differenceType), (String)"differenceType");
        ArgChecker.isTrue((eps >= MIN_EPS ? 1 : 0) != 0, (String)"eps of {} is too small. Please choose a value > {}, such as 1e-5*size of domain", (Object[])new Object[]{eps, MIN_EPS});
        this.differenceType = differenceType;
        this.eps = eps;
        this.twoEps = 2.0 * eps;
    }

    @Override
    public Function<DoubleArray, DoubleArray> differentiate(final Function<DoubleArray, Double> function) {
        ArgChecker.notNull(function, (String)"function");
        switch (this.differenceType) {
            case FORWARD: {
                return new Function<DoubleArray, DoubleArray>(){

                    @Override
                    public DoubleArray apply(DoubleArray x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        double y = (Double)function.apply(x);
                        return DoubleArray.of((int)x.size(), i -> {
                            double up = (Double)function.apply(x.with(i, x.get(i) + ScalarFieldFirstOrderDifferentiator.this.eps));
                            return (up - y) / ScalarFieldFirstOrderDifferentiator.this.eps;
                        });
                    }
                };
            }
            case CENTRAL: {
                return new Function<DoubleArray, DoubleArray>(){

                    @Override
                    public DoubleArray apply(DoubleArray x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        return DoubleArray.of((int)x.size(), i -> {
                            double up = (Double)function.apply(x.with(i, x.get(i) + ScalarFieldFirstOrderDifferentiator.this.eps));
                            double down = (Double)function.apply(x.with(i, x.get(i) - ScalarFieldFirstOrderDifferentiator.this.eps));
                            return (up - down) / ScalarFieldFirstOrderDifferentiator.this.twoEps;
                        });
                    }
                };
            }
            case BACKWARD: {
                return new Function<DoubleArray, DoubleArray>(){

                    @Override
                    public DoubleArray apply(DoubleArray x) {
                        ArgChecker.notNull((Object)x, (String)"x");
                        double y = (Double)function.apply(x);
                        return DoubleArray.of((int)x.size(), i -> {
                            double down = (Double)function.apply(x.with(i, x.get(i) - ScalarFieldFirstOrderDifferentiator.this.eps));
                            return (y - down) / ScalarFieldFirstOrderDifferentiator.this.eps;
                        });
                    }
                };
            }
        }
        throw new IllegalArgumentException("Can only handle forward, backward and central differencing");
    }

    @Override
    public Function<DoubleArray, DoubleArray> differentiate(final Function<DoubleArray, Double> function, final Function<DoubleArray, Boolean> domain) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull(domain, (String)"domain");
        final double[] wFwd = new double[]{-3.0 / this.twoEps, 4.0 / this.twoEps, -1.0 / this.twoEps};
        final double[] wCent = new double[]{-1.0 / this.twoEps, 0.0, 1.0 / this.twoEps};
        final double[] wBack = new double[]{1.0 / this.twoEps, -4.0 / this.twoEps, 3.0 / this.twoEps};
        return new Function<DoubleArray, DoubleArray>(){

            @Override
            public DoubleArray apply(DoubleArray x) {
                ArgChecker.notNull((Object)x, (String)"x");
                ArgChecker.isTrue((boolean)((Boolean)domain.apply(x)), (String)"point {} is not in the function domain", (Object[])new Object[]{x.toString()});
                return DoubleArray.of((int)x.size(), i -> {
                    double[] w;
                    double y1;
                    double y2;
                    double y0;
                    double xi = x.get(i);
                    DoubleArray xPlusOneEps = x.with(i, xi + ScalarFieldFirstOrderDifferentiator.this.eps);
                    DoubleArray xMinusOneEps = x.with(i, xi - ScalarFieldFirstOrderDifferentiator.this.eps);
                    if (!((Boolean)domain.apply(xPlusOneEps)).booleanValue()) {
                        DoubleArray xMinusTwoEps = x.with(i, xi - ScalarFieldFirstOrderDifferentiator.this.twoEps);
                        if (!((Boolean)domain.apply(xMinusTwoEps)).booleanValue()) {
                            throw new MathException("cannot get derivative at point " + x.toString() + " in direction " + i);
                        }
                        y0 = (Double)function.apply(xMinusTwoEps);
                        y2 = (Double)function.apply(x);
                        y1 = (Double)function.apply(xMinusOneEps);
                        w = wBack;
                    } else {
                        double temp = (Double)function.apply(xPlusOneEps);
                        if (!((Boolean)domain.apply(xMinusOneEps)).booleanValue()) {
                            y1 = temp;
                            y0 = (Double)function.apply(x);
                            y2 = (Double)function.apply(x.with(i, xi + ScalarFieldFirstOrderDifferentiator.this.twoEps));
                            w = wFwd;
                        } else {
                            y1 = 0.0;
                            y2 = temp;
                            y0 = (Double)function.apply(xMinusOneEps);
                            w = wCent;
                        }
                    }
                    double res = y0 * w[0] + y2 * w[2];
                    if (w[1] != 0.0) {
                        res += y1 * w[1];
                    }
                    return res;
                });
            }
        };
    }
}

