/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.differentiation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.differentiation.Differentiator;
import com.opengamma.strata.math.impl.differentiation.MatrixFieldFirstOrderDifferentiator;
import com.opengamma.strata.math.impl.differentiation.VectorFieldFirstOrderDifferentiator;
import java.util.function.Function;

public class VectorFieldSecondOrderDifferentiator
implements Differentiator<DoubleArray, DoubleArray, DoubleMatrix[]> {
    private static final double DEFAULT_EPS = 1.0E-4;
    private final double eps;
    private final double epsSqr;
    private final VectorFieldFirstOrderDifferentiator vectorFieldDiff;
    private final MatrixFieldFirstOrderDifferentiator maxtrixFieldDiff;

    public VectorFieldSecondOrderDifferentiator() {
        this.eps = 1.0E-4;
        this.epsSqr = this.eps * this.eps;
        this.vectorFieldDiff = new VectorFieldFirstOrderDifferentiator(this.eps);
        this.maxtrixFieldDiff = new MatrixFieldFirstOrderDifferentiator(this.eps);
    }

    @Override
    public Function<DoubleArray, DoubleMatrix[]> differentiate(Function<DoubleArray, DoubleArray> function) {
        ArgChecker.notNull(function, (String)"function");
        Function<DoubleArray, DoubleMatrix> jacFunc = this.vectorFieldDiff.differentiate(function);
        final Function<DoubleArray, DoubleMatrix[]> hFunc = this.maxtrixFieldDiff.differentiate(jacFunc);
        return new Function<DoubleArray, DoubleMatrix[]>(){

            @Override
            public DoubleMatrix[] apply(DoubleArray x) {
                DoubleMatrix[] gamma = (DoubleMatrix[])hFunc.apply(x);
                return VectorFieldSecondOrderDifferentiator.this.reshapeTensor(gamma);
            }
        };
    }

    @Override
    public Function<DoubleArray, DoubleMatrix[]> differentiate(Function<DoubleArray, DoubleArray> function, Function<DoubleArray, Boolean> domain) {
        ArgChecker.notNull(function, (String)"function");
        Function<DoubleArray, DoubleMatrix> jacFunc = this.vectorFieldDiff.differentiate(function, domain);
        final Function<DoubleArray, DoubleMatrix[]> hFunc = this.maxtrixFieldDiff.differentiate(jacFunc, domain);
        return new Function<DoubleArray, DoubleMatrix[]>(){

            @Override
            public DoubleMatrix[] apply(DoubleArray x) {
                DoubleMatrix[] gamma = (DoubleMatrix[])hFunc.apply(x);
                return VectorFieldSecondOrderDifferentiator.this.reshapeTensor(gamma);
            }
        };
    }

    private DoubleMatrix[] reshapeTensor(DoubleMatrix[] gamma) {
        int m = gamma.length;
        int n = gamma[0].rowCount();
        ArgChecker.isTrue((gamma[0].columnCount() == m ? 1 : 0) != 0, (String)"tenor wrong size. Seond index is {}, should be {}", (Object[])new Object[]{gamma[0].columnCount(), m});
        DoubleMatrix[] res = new DoubleMatrix[n];
        for (int i = 0; i < n; ++i) {
            int j;
            double[][] temp = new double[m][m];
            for (j = 0; j < m; ++j) {
                DoubleMatrix gammaJ = gamma[j];
                for (int k = j; k < m; ++k) {
                    temp[j][k] = gammaJ.get(i, k);
                }
            }
            for (j = 0; j < m; ++j) {
                for (int k = 0; k < j; ++k) {
                    temp[j][k] = temp[k][j];
                }
            }
            res[i] = DoubleMatrix.copyOf((double[][])temp);
        }
        return res;
    }

    public Function<DoubleArray, DoubleMatrix[]> differentiateFull(final Function<DoubleArray, DoubleArray> function) {
        return new Function<DoubleArray, DoubleMatrix[]>(){

            @Override
            public DoubleMatrix[] apply(DoubleArray x) {
                ArgChecker.notNull((Object)x, (String)"x");
                DoubleArray y = (DoubleArray)function.apply(x);
                int n = x.size();
                int m = y.size();
                double[][][] res = new double[m][n][n];
                for (int j = 0; j < n; ++j) {
                    double xj = x.get(j);
                    DoubleArray xPlusOneEps = x.with(j, xj + VectorFieldSecondOrderDifferentiator.this.eps);
                    DoubleArray xMinusOneEps = x.with(j, xj - VectorFieldSecondOrderDifferentiator.this.eps);
                    DoubleArray up = (DoubleArray)function.apply(x.with(j, xj + VectorFieldSecondOrderDifferentiator.this.eps));
                    DoubleArray down = (DoubleArray)function.apply(xMinusOneEps);
                    for (int i = 0; i < m; ++i) {
                        res[i][j][j] = (up.get(i) + down.get(i) - 2.0 * y.get(i)) / VectorFieldSecondOrderDifferentiator.this.epsSqr;
                    }
                    for (int k = j + 1; k < n; ++k) {
                        double xk = x.get(k);
                        DoubleArray downup = (DoubleArray)function.apply(xMinusOneEps.with(k, xk + VectorFieldSecondOrderDifferentiator.this.eps));
                        DoubleArray downdown = (DoubleArray)function.apply(xMinusOneEps.with(k, xk - VectorFieldSecondOrderDifferentiator.this.eps));
                        DoubleArray updown = (DoubleArray)function.apply(xPlusOneEps.with(k, xk - VectorFieldSecondOrderDifferentiator.this.eps));
                        DoubleArray upup = (DoubleArray)function.apply(xPlusOneEps.with(k, xk + VectorFieldSecondOrderDifferentiator.this.eps));
                        for (int i = 0; i < m; ++i) {
                            res[i][j][k] = (upup.get(i) + downdown.get(i) - updown.get(i) - downup.get(i)) / 4.0 / VectorFieldSecondOrderDifferentiator.this.epsSqr;
                        }
                    }
                }
                DoubleMatrix[] mres = new DoubleMatrix[m];
                for (int i = 0; i < m; ++i) {
                    for (int j = 0; j < n; ++j) {
                        for (int k = 0; k < j; ++k) {
                            res[i][j][k] = res[i][k][j];
                        }
                    }
                    mres[i] = DoubleMatrix.copyOf((double[][])res[i]);
                }
                return mres;
            }
        };
    }

    public Function<DoubleArray, DoubleMatrix> differentiateNoCross(final Function<DoubleArray, DoubleArray> function) {
        return new Function<DoubleArray, DoubleMatrix>(){

            @Override
            public DoubleMatrix apply(DoubleArray x) {
                ArgChecker.notNull((Object)x, (String)"x");
                DoubleArray y = (DoubleArray)function.apply(x);
                int n = x.size();
                int m = y.size();
                double[][] res = new double[m][n];
                for (int j = 0; j < n; ++j) {
                    double xj = x.get(j);
                    DoubleArray up = (DoubleArray)function.apply(x.with(j, xj + VectorFieldSecondOrderDifferentiator.this.eps));
                    DoubleArray down = (DoubleArray)function.apply(x.with(j, xj - VectorFieldSecondOrderDifferentiator.this.eps));
                    for (int i = 0; i < m; ++i) {
                        res[i][j] = (up.get(i) + down.get(i) - 2.0 * y.get(i)) / VectorFieldSecondOrderDifferentiator.this.epsSqr;
                    }
                }
                return DoubleMatrix.copyOf((double[][])res);
            }
        };
    }
}

