/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.differentiation.ScalarFieldFirstOrderDifferentiator;
import com.opengamma.strata.math.impl.function.ParameterizedFunction;
import java.util.function.Function;

public abstract class ParameterizedCurve
extends ParameterizedFunction<Double, DoubleArray, Double> {
    private static final ScalarFieldFirstOrderDifferentiator FIRST_ORDER_DIFF = new ScalarFieldFirstOrderDifferentiator();

    public Function<Double, DoubleArray> getYParameterSensitivity(final DoubleArray params) {
        return new Function<Double, DoubleArray>(){

            @Override
            public DoubleArray apply(Double x) {
                Function<DoubleArray, Double> f = ParameterizedCurve.this.asFunctionOfParameters(x);
                Function<DoubleArray, DoubleArray> g = FIRST_ORDER_DIFF.differentiate(f);
                return g.apply(params);
            }
        };
    }
}

