/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.function.ParameterizedCurve;
import com.opengamma.strata.math.impl.function.VectorFunction;
import java.util.Arrays;
import java.util.function.Function;

public class ParameterizedCurveVectorFunction
extends VectorFunction {
    private final double[] _samplePoints;
    private final ParameterizedCurve _curve;

    public ParameterizedCurveVectorFunction(double[] samplePoints, ParameterizedCurve curve) {
        ArgChecker.notEmpty((double[])samplePoints, (String)"samplePoints");
        ArgChecker.notNull((Object)curve, (String)"curve");
        this._samplePoints = Arrays.copyOf(samplePoints, samplePoints.length);
        this._curve = curve;
    }

    @Override
    public DoubleMatrix calculateJacobian(DoubleArray x) {
        Function<Double, DoubleArray> sense = this._curve.getYParameterSensitivity(x);
        return DoubleMatrix.ofArrayObjects((int)this.getLengthOfRange(), (int)this.getLengthOfDomain(), i -> (DoubleArray)sense.apply(this._samplePoints[i]));
    }

    @Override
    public int getLengthOfDomain() {
        return this._curve.getNumberOfParameters();
    }

    @Override
    public int getLengthOfRange() {
        return this._samplePoints.length;
    }

    @Override
    public DoubleArray apply(DoubleArray curveParameters) {
        Function func = this._curve.asFunctionOfArguments(curveParameters);
        return DoubleArray.of((int)this._samplePoints.length, i -> (Double)func.apply(this._samplePoints[i]));
    }
}

