/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.ArgChecker;
import java.util.function.Function;

public abstract class ParameterizedFunction<S, T, U> {
    public abstract U evaluate(S var1, T var2);

    public Function<T, U> asFunctionOfParameters(final S x) {
        ArgChecker.notNull(x, (String)"x");
        return new Function<T, U>(){

            @Override
            public U apply(T params) {
                return ParameterizedFunction.this.evaluate(x, params);
            }
        };
    }

    public Function<S, U> asFunctionOfArguments(final T params) {
        ArgChecker.notNull(params, (String)"params");
        return new Function<S, U>(){

            @Override
            public U apply(S x) {
                return ParameterizedFunction.this.evaluate(x, params);
            }
        };
    }

    public abstract int getNumberOfParameters();
}

