/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult2D;

public class PiecewisePolynomialFunction2D {
    public double evaluate(PiecewisePolynomialResult2D pp, double x0Key, double x1Key) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.isFalse((boolean)Double.isNaN(x0Key), (String)"x0Key containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(x0Key), (String)"x0Key containing Infinity");
        ArgChecker.isFalse((boolean)Double.isNaN(x1Key), (String)"x1Key containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(x1Key), (String)"x1Key containing Infinity");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        int ind0 = 0;
        int ind1 = 0;
        for (int k = 1; k < nKnots0 - 1; ++k) {
            if (!(x0Key >= knots0.get(k))) continue;
            ind0 = k;
        }
        for (int i = 1; i < nKnots1 - 1; ++i) {
            if (!(x1Key >= knots1.get(i))) continue;
            ind1 = i;
        }
        double res = this.getValue(pp.getCoefs()[ind0][ind1], x0Key, x1Key, knots0.get(ind0), knots1.get(ind1));
        ArgChecker.isFalse((boolean)Double.isInfinite(res), (String)"Too large input");
        ArgChecker.isFalse((boolean)Double.isNaN(res), (String)"Too large input");
        return res;
    }

    public DoubleMatrix evaluate(PiecewisePolynomialResult2D pp, double[] x0Keys, double[] x1Keys) {
        int i;
        ArgChecker.notNull((Object)pp, (String)"pp");
        ArgChecker.notNull((Object)x0Keys, (String)"x0Keys");
        ArgChecker.notNull((Object)x1Keys, (String)"x1Keys");
        int n0Keys = x0Keys.length;
        int n1Keys = x1Keys.length;
        for (i = 0; i < n0Keys; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(x0Keys[i]), (String)"x0Keys containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(x0Keys[i]), (String)"x0Keys containing Infinity");
        }
        for (i = 0; i < n1Keys; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(x1Keys[i]), (String)"x1Keys containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(x1Keys[i]), (String)"x1Keys containing Infinity");
        }
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        double[][] res = new double[n0Keys][n1Keys];
        for (int i2 = 0; i2 < n0Keys; ++i2) {
            for (int j = 0; j < n1Keys; ++j) {
                int k;
                int ind0 = 0;
                int ind1 = 0;
                for (k = 1; k < nKnots0 - 1; ++k) {
                    if (!(x0Keys[i2] >= knots0.get(k))) continue;
                    ind0 = k;
                }
                for (k = 1; k < nKnots1 - 1; ++k) {
                    if (!(x1Keys[j] >= knots1.get(k))) continue;
                    ind1 = k;
                }
                res[i2][j] = this.getValue(pp.getCoefs()[ind0][ind1], x0Keys[i2], x1Keys[j], knots0.get(ind0), knots1.get(ind1));
                ArgChecker.isFalse((boolean)Double.isInfinite(res[i2][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isNaN(res[i2][j]), (String)"Too large input");
            }
        }
        return DoubleMatrix.copyOf((double[][])res);
    }

    public double differentiateX0(PiecewisePolynomialResult2D pp, double x0Key, double x1Key) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order0 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x0 < 1");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)(order0 - 1), (int)order1, (k, l) -> coef.get(k, l) * (double)(order0 - k - 1));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0 - 1, order1});
        return this.evaluate(ppDiff, x0Key, x1Key);
    }

    public double differentiateX1(PiecewisePolynomialResult2D pp, double x0Key, double x1Key) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order1 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x1 < 1");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)order0, (int)(order1 - 1), (k, l) -> coef.get(k, l) * (double)(order1 - l - 1));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0, order1 - 1});
        return this.evaluate(ppDiff, x0Key, x1Key);
    }

    public DoubleMatrix differentiateX0(PiecewisePolynomialResult2D pp, double[] x0Keys, double[] x1Keys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order0 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x0 < 1");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)(order0 - 1), (int)order1, (k, l) -> coef.get(k, l) * (double)(order0 - k - 1));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0 - 1, order1});
        return this.evaluate(ppDiff, x0Keys, x1Keys);
    }

    public DoubleMatrix differentiateX1(PiecewisePolynomialResult2D pp, double[] x0Keys, double[] x1Keys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order1 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x1 < 1");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)order0, (int)(order1 - 1), (k, l) -> coef.get(k, l) * (double)(order1 - l - 1));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0, order1 - 1});
        return this.evaluate(ppDiff, x0Keys, x1Keys);
    }

    public double differentiateCross(PiecewisePolynomialResult2D pp, double x0Key, double x1Key) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order0 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x0 < 1");
        ArgChecker.isFalse((order1 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x1 < 1");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)(order0 - 1), (int)(order1 - 1), (k, l) -> coef.get(k, l) * (double)(order1 - l - 1) * (double)(order0 - k - 1));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0 - 1, order1 - 1});
        return this.evaluate(ppDiff, x0Key, x1Key);
    }

    public double differentiateTwiceX0(PiecewisePolynomialResult2D pp, double x0Key, double x1Key) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order0 < 3 ? 1 : 0) != 0, (String)"polynomial degree of x0 < 2");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)(order0 - 2), (int)order1, (k, l) -> coef.get(k, l) * (double)(order0 - k - 1) * (double)(order0 - k - 2));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0 - 2, order1});
        return this.evaluate(ppDiff, x0Key, x1Key);
    }

    public double differentiateTwiceX1(PiecewisePolynomialResult2D pp, double x0Key, double x1Key) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order1 < 3 ? 1 : 0) != 0, (String)"polynomial degree of x1 < 2");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)order0, (int)(order1 - 2), (k, l) -> coef.get(k, l) * (double)(order1 - l - 1) * (double)(order1 - l - 2));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0, order1 - 2});
        return this.evaluate(ppDiff, x0Key, x1Key);
    }

    public DoubleMatrix differentiateCross(PiecewisePolynomialResult2D pp, double[] x0Keys, double[] x1Keys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order0 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x0 < 1");
        ArgChecker.isFalse((order1 < 2 ? 1 : 0) != 0, (String)"polynomial degree of x1 < 1");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)(order0 - 1), (int)(order1 - 1), (k, l) -> coef.get(k, l) * (double)(order1 - l - 1) * (double)(order0 - k - 1));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0 - 1, order1 - 1});
        return this.evaluate(ppDiff, x0Keys, x1Keys);
    }

    public DoubleMatrix differentiateTwiceX0(PiecewisePolynomialResult2D pp, double[] x0Keys, double[] x1Keys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order0 < 3 ? 1 : 0) != 0, (String)"polynomial degree of x0 < 2");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)(order0 - 2), (int)order1, (k, l) -> coef.get(k, l) * (double)(order0 - k - 1) * (double)(order0 - k - 2));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0 - 2, order1});
        return this.evaluate(ppDiff, x0Keys, x1Keys);
    }

    public DoubleMatrix differentiateTwiceX1(PiecewisePolynomialResult2D pp, double[] x0Keys, double[] x1Keys) {
        ArgChecker.notNull((Object)pp, (String)"pp");
        int order0 = pp.getOrder()[0];
        int order1 = pp.getOrder()[1];
        ArgChecker.isFalse((order1 < 3 ? 1 : 0) != 0, (String)"polynomial degree of x1 < 2");
        DoubleArray knots0 = pp.getKnots0();
        DoubleArray knots1 = pp.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        DoubleMatrix[][] coefs = pp.getCoefs();
        DoubleMatrix[][] res = new DoubleMatrix[nKnots0][nKnots1];
        for (int i = 0; i < nKnots0 - 1; ++i) {
            for (int j = 0; j < nKnots1 - 1; ++j) {
                DoubleMatrix coef = coefs[i][j];
                res[i][j] = DoubleMatrix.of((int)order0, (int)(order1 - 2), (k, l) -> coef.get(k, l) * (double)(order1 - l - 1) * (double)(order1 - l - 2));
            }
        }
        PiecewisePolynomialResult2D ppDiff = new PiecewisePolynomialResult2D(knots0, knots1, res, new int[]{order0, order1 - 2});
        return this.evaluate(ppDiff, x0Keys, x1Keys);
    }

    private double getValue(DoubleMatrix coefMat, double x0, double x1, double leftKnot0, double leftKnot1) {
        int order0 = coefMat.rowCount();
        int order1 = coefMat.columnCount();
        double x0Mod = x0 - leftKnot0;
        double x1Mod = x1 - leftKnot1;
        double res = 0.0;
        for (int i = 0; i < order0; ++i) {
            for (int j = 0; j < order1; ++j) {
                res += coefMat.get(order0 - i - 1, order1 - j - 1) * Math.pow(x0Mod, i) * Math.pow(x1Mod, j);
            }
        }
        return res;
    }
}

