/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import java.util.Arrays;

public class RealPolynomialFunction1D
implements DoubleFunction1D {
    private final double[] _coefficients;
    private final int _n;

    public RealPolynomialFunction1D(double ... coefficients) {
        ArgChecker.notNull((Object)coefficients, (String)"coefficients");
        ArgChecker.isTrue((coefficients.length > 0 ? 1 : 0) != 0, (String)"coefficients length must be greater than zero");
        this._coefficients = coefficients;
        this._n = this._coefficients.length;
    }

    @Override
    public double applyAsDouble(double x) {
        ArgChecker.notNull((Object)x, (String)"x");
        double y = this._coefficients[this._n - 1];
        for (int i = this._n - 2; i >= 0; --i) {
            y = x * y + this._coefficients[i];
        }
        return y;
    }

    public double[] getCoefficients() {
        return this._coefficients;
    }

    @Override
    public DoubleFunction1D add(DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"function");
        if (f instanceof RealPolynomialFunction1D) {
            RealPolynomialFunction1D p1 = (RealPolynomialFunction1D)f;
            double[] c1 = p1.getCoefficients();
            double[] c = this._coefficients;
            int n = c1.length;
            boolean longestIsNew = n > this._n;
            double[] c3 = longestIsNew ? Arrays.copyOf(c1, n) : Arrays.copyOf(c, this._n);
            for (int i = 0; i < (longestIsNew ? this._n : n); ++i) {
                int n2 = i;
                c3[n2] = c3[n2] + (longestIsNew ? c[i] : c1[i]);
            }
            return new RealPolynomialFunction1D(c3);
        }
        return DoubleFunction1D.super.add(f);
    }

    @Override
    public RealPolynomialFunction1D add(double a) {
        double[] c = Arrays.copyOf(this.getCoefficients(), this._n);
        c[0] = c[0] + a;
        return new RealPolynomialFunction1D(c);
    }

    @Override
    public RealPolynomialFunction1D derivative() {
        int n = this._coefficients.length - 1;
        double[] coefficients = new double[n];
        for (int i = 1; i <= n; ++i) {
            coefficients[i - 1] = (double)i * this._coefficients[i];
        }
        return new RealPolynomialFunction1D(coefficients);
    }

    @Override
    public RealPolynomialFunction1D divide(double a) {
        double[] c = Arrays.copyOf(this.getCoefficients(), this._n);
        int i = 0;
        while (i < this._n) {
            int n = i++;
            c[n] = c[n] / a;
        }
        return new RealPolynomialFunction1D(c);
    }

    @Override
    public DoubleFunction1D multiply(DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"function");
        if (f instanceof RealPolynomialFunction1D) {
            RealPolynomialFunction1D p1 = (RealPolynomialFunction1D)f;
            double[] c = this._coefficients;
            double[] c1 = p1.getCoefficients();
            int m = c1.length;
            double[] newC = new double[this._n + m - 1];
            for (int i = 0; i < newC.length; ++i) {
                newC[i] = 0.0;
                for (int j = Math.max(0, i + 1 - m); j < Math.min(this._n, i + 1); ++j) {
                    int n = i;
                    newC[n] = newC[n] + c[j] * c1[i - j];
                }
            }
            return new RealPolynomialFunction1D(newC);
        }
        return DoubleFunction1D.super.multiply(f);
    }

    @Override
    public RealPolynomialFunction1D multiply(double a) {
        double[] c = Arrays.copyOf(this.getCoefficients(), this._n);
        int i = 0;
        while (i < this._n) {
            int n = i++;
            c[n] = c[n] * a;
        }
        return new RealPolynomialFunction1D(c);
    }

    @Override
    public DoubleFunction1D subtract(DoubleFunction1D f) {
        ArgChecker.notNull((Object)f, (String)"function");
        if (f instanceof RealPolynomialFunction1D) {
            int i;
            RealPolynomialFunction1D p1 = (RealPolynomialFunction1D)f;
            double[] c = this._coefficients;
            double[] c1 = p1.getCoefficients();
            int m = c.length;
            int n = c1.length;
            int min = Math.min(m, n);
            int max = Math.max(m, n);
            double[] c3 = new double[max];
            for (i = 0; i < min; ++i) {
                c3[i] = c[i] - c1[i];
            }
            for (i = min; i < max; ++i) {
                c3[i] = m == max ? c[i] : -c1[i];
            }
            return new RealPolynomialFunction1D(c3);
        }
        return DoubleFunction1D.super.subtract(f);
    }

    @Override
    public RealPolynomialFunction1D subtract(double a) {
        double[] c = Arrays.copyOf(this.getCoefficients(), this._n);
        c[0] = c[0] - a;
        return new RealPolynomialFunction1D(c);
    }

    public RealPolynomialFunction1D toMonic() {
        double an = this._coefficients[this._n - 1];
        if (DoubleMath.fuzzyEquals((double)an, (double)1.0, (double)1.0E-15)) {
            return new RealPolynomialFunction1D(Arrays.copyOf(this._coefficients, this._n));
        }
        double[] rescaled = new double[this._n];
        for (int i = 0; i < this._n; ++i) {
            rescaled[i] = this._coefficients[i] / an;
        }
        return new RealPolynomialFunction1D(rescaled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealPolynomialFunction1D other = (RealPolynomialFunction1D)obj;
        return Arrays.equals(this._coefficients, other._coefficients);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this._coefficients);
        return result;
    }
}

