/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.function.special.OrthogonalPolynomialFunctionGenerator;

public class LaguerrePolynomialFunction
extends OrthogonalPolynomialFunctionGenerator {
    private static final DoubleFunction1D F1 = new RealPolynomialFunction1D(1.0, -1.0);
    private static final DoubleFunction1D DF1 = new RealPolynomialFunction1D(-1.0);

    @Override
    public DoubleFunction1D[] getPolynomials(int n) {
        return this.getPolynomials(n, 0.0);
    }

    @Override
    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n) {
        return this.getPolynomialsAndFirstDerivative(n, 0.0);
    }

    public DoubleFunction1D[] getPolynomials(int n, double alpha) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        DoubleFunction1D[] polynomials = new DoubleFunction1D[n + 1];
        for (int i = 0; i <= n; ++i) {
            polynomials[i] = i == 0 ? this.getOne() : (i == 1 ? new RealPolynomialFunction1D(1.0 + alpha, -1.0) : polynomials[i - 1].multiply(2.0 * (double)i + alpha - 1.0).subtract(polynomials[i - 1].multiply(this.getX())).subtract(polynomials[i - 2].multiply((double)i - 1.0 + alpha)).divide(i));
        }
        return polynomials;
    }

    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n, double alpha) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        Pair[] polynomials = new Pair[n + 1];
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                polynomials[i] = Pair.of((Object)this.getOne(), (Object)this.getZero());
                continue;
            }
            if (i == 1) {
                polynomials[i] = Pair.of((Object)F1, (Object)DF1);
                continue;
            }
            DoubleFunction1D p1 = (DoubleFunction1D)polynomials[i - 1].getFirst();
            DoubleFunction1D p2 = (DoubleFunction1D)polynomials[i - 2].getFirst();
            DoubleFunction1D p = p1.multiply(2.0 * (double)i + alpha - 1.0).subtract(p1.multiply(this.getX())).subtract(p2.multiply((double)i - 1.0 + alpha)).divide(i);
            DoubleFunction1D dp = p.multiply(i).subtract(p1.multiply((double)i + alpha)).divide(this.getX());
            polynomials[i] = Pair.of((Object)p, (Object)dp);
        }
        return polynomials;
    }
}

