/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.function.special;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.special.OrthogonalPolynomialFunctionGenerator;

public class LegendrePolynomialFunction
extends OrthogonalPolynomialFunctionGenerator {
    @Override
    public DoubleFunction1D[] getPolynomials(int n) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        DoubleFunction1D[] polynomials = new DoubleFunction1D[n + 1];
        for (int i = 0; i <= n; ++i) {
            polynomials[i] = i == 0 ? this.getOne() : (i == 1 ? this.getX() : polynomials[i - 1].multiply(this.getX()).multiply(2 * i - 1).subtract(polynomials[i - 2].multiply(i - 1)).multiply(1.0 / (double)i));
        }
        return polynomials;
    }

    @Override
    public Pair<DoubleFunction1D, DoubleFunction1D>[] getPolynomialsAndFirstDerivative(int n) {
        ArgChecker.isTrue((n >= 0 ? 1 : 0) != 0);
        Pair[] polynomials = new Pair[n + 1];
        for (int i = 0; i <= n; ++i) {
            if (i == 0) {
                polynomials[i] = Pair.of((Object)this.getOne(), (Object)this.getZero());
                continue;
            }
            if (i == 1) {
                polynomials[i] = Pair.of((Object)this.getX(), (Object)this.getOne());
                continue;
            }
            DoubleFunction1D p = ((DoubleFunction1D)polynomials[i - 1].getFirst()).multiply(this.getX()).multiply(2 * i - 1).subtract(((DoubleFunction1D)polynomials[i - 2].getFirst()).multiply(i - 1)).multiply(1.0 / (double)i);
            DoubleFunction1D dp = p.derivative();
            polynomials[i] = Pair.of((Object)p, (Object)dp);
        }
        return polynomials;
    }
}

