/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.integration.GaussHermiteWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureIntegrator1D;
import java.util.function.Function;

public class GaussHermiteQuadratureIntegrator1D
extends GaussianQuadratureIntegrator1D {
    private static final Double[] LIMITS = new Double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
    private static final GaussHermiteWeightAndAbscissaFunction GENERATOR = new GaussHermiteWeightAndAbscissaFunction();

    public GaussHermiteQuadratureIntegrator1D(int n) {
        super(n, GENERATOR);
    }

    @Override
    public Double[] getLimits() {
        return LIMITS;
    }

    @Override
    public Function<Double, Double> getIntegralFunction(final Function<Double, Double> function, Double lower, Double upper) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull((Object)lower, (String)"lower");
        ArgChecker.notNull((Object)upper, (String)"upper");
        if (lower.equals(LIMITS[0]) && upper.equals(LIMITS[1])) {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    return Math.exp(x * x) * (Double)function.apply(x);
                }
            };
        }
        throw new UnsupportedOperationException("Limits for this integration method are +/-infinity");
    }
}

