/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.special.OrthonormalHermitePolynomialFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureData;
import com.opengamma.strata.math.impl.integration.QuadratureWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.rootfinding.NewtonRaphsonSingleRootFinder;

public class GaussHermiteWeightAndAbscissaFunction
implements QuadratureWeightAndAbscissaFunction {
    private static final OrthonormalHermitePolynomialFunction HERMITE = new OrthonormalHermitePolynomialFunction();
    private static final NewtonRaphsonSingleRootFinder ROOT_FINDER = new NewtonRaphsonSingleRootFinder(1.0E-12);

    @Override
    public GaussianQuadratureData generate(int n) {
        ArgChecker.isTrue((n > 0 ? 1 : 0) != 0);
        double[] x = new double[n];
        double[] w = new double[n];
        boolean odd = n % 2 != 0;
        int m = (n + 1) / 2 - (odd ? 1 : 0);
        Pair<DoubleFunction1D, DoubleFunction1D>[] polynomials = HERMITE.getPolynomialsAndFirstDerivative(n);
        Pair<DoubleFunction1D, DoubleFunction1D> pair = polynomials[n];
        DoubleFunction1D function = (DoubleFunction1D)pair.getFirst();
        DoubleFunction1D derivative = (DoubleFunction1D)pair.getSecond();
        double root = 0.0;
        for (int i = 0; i < m; ++i) {
            root = this.getInitialRootGuess(root, i, n, x);
            root = ROOT_FINDER.getRoot(function, derivative, (Double)root);
            double dp = derivative.applyAsDouble(root);
            x[i] = -root;
            x[n - 1 - i] = root;
            w[i] = 2.0 / (dp * dp);
            w[n - 1 - i] = w[i];
        }
        if (odd) {
            double dp = derivative.applyAsDouble(0.0);
            w[m] = 2.0 / dp / dp;
        }
        return new GaussianQuadratureData(x, w);
    }

    private double getInitialRootGuess(double previousRoot, int i, int n, double[] x) {
        if (i == 0) {
            return Math.sqrt(2 * n + 1) - 1.85575 * Math.pow(2 * n + 1, -0.16666666666666666);
        }
        if (i == 1) {
            return previousRoot - 1.14 * Math.pow(n, 0.426) / previousRoot;
        }
        if (i == 2) {
            return 1.86 * previousRoot + 0.86 * x[0];
        }
        if (i == 3) {
            return 1.91 * previousRoot + 0.91 * x[1];
        }
        return 2.0 * previousRoot + x[i - 2];
    }
}

