/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.math.impl.integration.GaussLaguerreWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureIntegrator1D;
import java.util.function.Function;

public class GaussLaguerreQuadratureIntegrator1D
extends GaussianQuadratureIntegrator1D {
    private static final Double[] LIMITS = new Double[]{0.0, Double.POSITIVE_INFINITY};

    public GaussLaguerreQuadratureIntegrator1D(int n) {
        super(n, new GaussLaguerreWeightAndAbscissaFunction());
    }

    public GaussLaguerreQuadratureIntegrator1D(int n, double alpha) {
        super(n, new GaussLaguerreWeightAndAbscissaFunction(alpha));
    }

    @Override
    public Double[] getLimits() {
        return LIMITS;
    }

    @Override
    public Function<Double, Double> getIntegralFunction(final Function<Double, Double> function, Double lower, Double upper) {
        if (lower.equals(LIMITS[0]) && upper.equals(LIMITS[1])) {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    return (Double)function.apply(x) * Math.exp(x);
                }
            };
        }
        throw new UnsupportedOperationException("Limits for Gauss-Laguerre integration are 0 and +infinity");
    }
}

