/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.special.GammaFunction;
import com.opengamma.strata.math.impl.function.special.LaguerrePolynomialFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureData;
import com.opengamma.strata.math.impl.integration.QuadratureWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.rootfinding.NewtonRaphsonSingleRootFinder;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class GaussLaguerreWeightAndAbscissaFunction
implements QuadratureWeightAndAbscissaFunction {
    private static final LaguerrePolynomialFunction LAGUERRE = new LaguerrePolynomialFunction();
    private static final NewtonRaphsonSingleRootFinder ROOT_FINDER = new NewtonRaphsonSingleRootFinder(1.0E-10);
    private static final DoubleUnaryOperator GAMMA_FUNCTION = new GammaFunction();
    private final double _alpha;

    public GaussLaguerreWeightAndAbscissaFunction() {
        this(0.0);
    }

    public GaussLaguerreWeightAndAbscissaFunction(double alpha) {
        this._alpha = alpha;
    }

    @Override
    public GaussianQuadratureData generate(int n) {
        ArgChecker.isTrue((n > 0 ? 1 : 0) != 0);
        Pair<DoubleFunction1D, DoubleFunction1D>[] polynomials = LAGUERRE.getPolynomialsAndFirstDerivative(n, this._alpha);
        Pair<DoubleFunction1D, DoubleFunction1D> pair = polynomials[n];
        DoubleFunction1D p1 = (DoubleFunction1D)polynomials[n - 1].getFirst();
        DoubleFunction1D function = (DoubleFunction1D)pair.getFirst();
        DoubleFunction1D derivative = (DoubleFunction1D)pair.getSecond();
        double[] x = new double[n];
        double[] w = new double[n];
        double root = 0.0;
        for (int i = 0; i < n; ++i) {
            x[i] = root = ROOT_FINDER.getRoot(function, derivative, (Double)this.getInitialRootGuess(root, i, n, x)).doubleValue();
            w[i] = -GAMMA_FUNCTION.applyAsDouble(this._alpha + (double)n) / CombinatoricsUtils.factorialDouble((int)n) / (derivative.applyAsDouble(root) * p1.applyAsDouble(root));
        }
        return new GaussianQuadratureData(x, w);
    }

    private double getInitialRootGuess(double previousRoot, int i, int n, double[] x) {
        if (i == 0) {
            return (1.0 + this._alpha) * (3.0 + 0.92 * this._alpha) / (1.0 + 1.8 * this._alpha + 2.4 * (double)n);
        }
        if (i == 1) {
            return previousRoot + (15.0 + 6.25 * this._alpha) / (1.0 + 0.9 * this._alpha + 2.5 * (double)n);
        }
        int j = i - 1;
        return previousRoot + ((1.0 + 2.55 * (double)j) / 1.9 / (double)j + 1.26 * (double)j * this._alpha / (1.0 + 3.5 * (double)j)) * (previousRoot - x[i - 2]) / (1.0 + 0.3 * this._alpha);
    }
}

