/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.function.DoubleFunction1D;
import com.opengamma.strata.math.impl.function.special.LegendrePolynomialFunction;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureData;
import com.opengamma.strata.math.impl.integration.QuadratureWeightAndAbscissaFunction;
import com.opengamma.strata.math.impl.rootfinding.NewtonRaphsonSingleRootFinder;

public class GaussLegendreWeightAndAbscissaFunction
implements QuadratureWeightAndAbscissaFunction {
    private static final LegendrePolynomialFunction LEGENDRE = new LegendrePolynomialFunction();
    private static final NewtonRaphsonSingleRootFinder ROOT_FINDER = new NewtonRaphsonSingleRootFinder(1.0E-15);

    @Override
    public GaussianQuadratureData generate(int n) {
        ArgChecker.isTrue((n > 0 ? 1 : 0) != 0);
        int mid = (n + 1) / 2;
        double[] x = new double[n];
        double[] w = new double[n];
        Pair<DoubleFunction1D, DoubleFunction1D>[] polynomials = LEGENDRE.getPolynomialsAndFirstDerivative(n);
        Pair<DoubleFunction1D, DoubleFunction1D> pair = polynomials[n];
        DoubleFunction1D function = (DoubleFunction1D)pair.getFirst();
        DoubleFunction1D derivative = (DoubleFunction1D)pair.getSecond();
        for (int i = 0; i < mid; ++i) {
            double root = ROOT_FINDER.getRoot(function, derivative, (Double)this.getInitialRootGuess(i, n));
            x[i] = -root;
            x[n - i - 1] = root;
            double dp = derivative.applyAsDouble(root);
            w[i] = 2.0 / ((1.0 - root * root) * dp * dp);
            w[n - i - 1] = w[i];
        }
        return new GaussianQuadratureData(x, w);
    }

    private double getInitialRootGuess(int i, int n) {
        return Math.cos(Math.PI * ((double)i + 0.75) / ((double)n + 0.5));
    }
}

