/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.integration.GaussianQuadratureData;
import com.opengamma.strata.math.impl.integration.Integrator1D;
import com.opengamma.strata.math.impl.integration.QuadratureWeightAndAbscissaFunction;
import java.util.Objects;
import java.util.function.Function;

public abstract class GaussianQuadratureIntegrator1D
extends Integrator1D<Double, Double> {
    private final int size;
    private final QuadratureWeightAndAbscissaFunction generator;
    private final GaussianQuadratureData quadrature;

    public GaussianQuadratureIntegrator1D(int n, QuadratureWeightAndAbscissaFunction generator) {
        ArgChecker.isTrue((n > 0 ? 1 : 0) != 0, (String)"number of intervals must be > 0");
        ArgChecker.notNull((Object)generator, (String)"generating function");
        this.size = n;
        this.generator = generator;
        this.quadrature = generator.generate(this.size);
    }

    @Override
    public Double integrate(Function<Double, Double> function, Double lower, Double upper) {
        ArgChecker.notNull(function, (String)"function");
        ArgChecker.notNull((Object)lower, (String)"lower");
        ArgChecker.notNull((Object)upper, (String)"upper");
        Function<Double, Double> integral = this.getIntegralFunction(function, lower, upper);
        return this.integrateFromPolyFunc(integral);
    }

    public double integrateFromPolyFunc(Function<Double, Double> polyFunction) {
        ArgChecker.notNull(polyFunction, (String)"polyFunction");
        double[] abscissas = this.quadrature.getAbscissas();
        int n = abscissas.length;
        double[] weights = this.quadrature.getWeights();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += polyFunction.apply(abscissas[i]) * weights[i];
        }
        return sum;
    }

    public abstract Double[] getLimits();

    public abstract Function<Double, Double> getIntegralFunction(Function<Double, Double> var1, Double var2, Double var3);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.generator.hashCode();
        result = prime * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GaussianQuadratureIntegrator1D other = (GaussianQuadratureIntegrator1D)obj;
        if (this.size != other.size) {
            return false;
        }
        return Objects.equals(this.generator, other.generator);
    }
}

